/*
 * $Header: /home/campbell/Languages/Scheme/scm/x-scm/RCS/xt.h,v 1.3 1992/07/23 11:33:22 campbell Beta $
 *
 * Author: Larry Campbell (campbell@redsox.bsw.com)
 *
 * Copyright 1992 by The Boston Software Works, Inc.
 * Permission to use for any purpose whatsoever granted, as long
 * as this copyright notice remains intact.  Please send bug fixes
 * or enhancements to the above email address.
 *
 * X Toolkit interface for scm - common definitions
 */

typedef struct {
    char	*wc_name;
    WidgetClass	*wc_class;
} xt_widget_class_t;

#define WIDGETP(x) (TYP16(x) == tc16_widget)
#define WIDGET(x) ((Widget) CDR(x))
#define WIDGETCLASSP(x) (TYP16(x) == tc16_widget_class)
#define WIDGETCLASS(x) ((WidgetClass) CDR(x))
#ifdef MOTIF
#define XMSTRINGP(x) (TYP16(x) == tc16_xmstring)
#define XMSTRING(x) ((XmString) CDR(x))
#define XMSTRINGTABLEP(x) (TYP16(x) == tc16_xmstringtable)
#define XMSTRINGTABLE(x) ((XmStringTable) CDR(x))
#define XMSTRINGTABLE_LENGTH(x) (CAR(x)>>16)
#define SET_XMSTRINGTABLE_LENGTH(x,v,t) CAR(x) = ((v)<<16)+t
#endif /* MOTIF */

extern SCM	 make_widget();
extern SCM	 make_widget_class();
extern void	 xt_init_widget_classes();

extern long	 tc16_widget;
#ifdef MOTIF
extern long	 tc16_xmstring;
extern long	 tc16_xmstringtable;
#endif
