# Unix chapter
proc FindFile { startDir namePat } {
	set pwd [pwd]
	if [catch {cd $startDir} err] {
		puts stderr $err
		return
	}
	foreach match [glob -nocomplain -- $namePat]{
		puts stdout $startDir/$match
	}
	foreach file [glob -nocomplain *] {
		if [file isdirectory $file] {
			FindFile $startDir/$file $namePat
		}
	}
	cd $pwd
}
