'\" -*- tcl -*- doctools manpage
'\"
'\" Generated from ../tcllib/modules/profiler/profiler.man by mpexpand with fmt.nroff
'\"
.so man.macros
.TH "profiler" n 0.2 profiler "Tcl Profiler"
.BS
.SH NAME
profiler \- Tcl source code profiler
.SH "SYNOPSIS"
package require \fBTcl 8.3\fR
.sp
package require \fBprofiler ?0.2?\fR
.sp
\fB::profiler::init\fR \fR
.sp
\fB::profiler::dump\fR \fIpattern\fR\fR
.sp
\fB::profiler::print\fR ?\fIpattern\fR?\fR
.sp
\fB::profiler::reset\fR \fR
.sp
\fB::profiler::suspend\fR ?\fIpattern\fR?\fR
.sp
\fB::profiler::resume\fR ?\fIpattern\fR?\fR
.sp
\fB::profiler::sortFunctions\fR \fIkey\fR\fR
.sp
.BE
.SH "DESCRIPTION"
.PP
The \fBprofiler\fR package provides a simple Tcl source code
profiler.  It is a function-level profiler; that is, it collects only
function-level information, not the more detailed line-level
information.  It operates by redefining the Tcl \fBproc\fR command.
Profiling is initiated via the \fB::profiler::init\fR command.
.SH "COMMANDS"
.TP
\fB::profiler::init\fR \fR
Initiate profiling.  All procedures created after this command is
called will be profiled.  To profile an entire application, this
command must be called before any other commands.
.TP
\fB::profiler::dump\fR \fIpattern\fR\fR
Dump profiling information for the all functions matching
\fIpattern\fR.  If no pattern is specified, information for all
functions will be returned.  The result is a list of key/value pairs
that maps function names to information about that function.  The
information about each function is in turn a list of key/value pairs.
The keys used and their values are:
.RS
.TP
\fBtotalCalls\fR
The total number of times \fIfunctionName\fR was called.
.TP
\fBcallerDist\fR
A list of key/value pairs mapping each calling function that called
\fIfunctionName\fR to the number of times it called
\fIfunctionName\fR.
.TP
\fBcompileTime\fR
The runtime, in clock clicks, of \fIfunctionName\fR the first time
that it was called.
.TP
\fBtotalRuntime\fR
The sum of the runtimes of all calls of \fIfunctionName\fR.
.TP
\fBaverageRuntime\fR
Average runtime of \fIfunctionName\fR.
.TP
\fBdescendantTime\fR
Sum of the time spent in descendants of \fIfunctionName\fR.
.TP
\fBaverageDescendantTime\fR
Average time spent in descendants of \fIfunctionName\fR.
.RE
.TP
\fB::profiler::print\fR ?\fIpattern\fR?\fR
Print profiling information for all functions matching \fIpattern\fR.
If no pattern is specified, information about all functions will be
displayed.  The return result is a human readable display of the
profiling information.
.TP
\fB::profiler::reset\fR \fR
Reset profiling information for all functions matching \fIpattern\fR.
If no pattern is specified, information will be reset for all
functions.
.TP
\fB::profiler::suspend\fR ?\fIpattern\fR?\fR
Suspend profiling for all functions matching \fIpattern\fR.  If no
pattern is specified, profiling will be suspended for all
functions. It stops gathering profiling information after this command
is issued. However, it does not erase any profiling information that
has been gathered previously.  Use resume command to re-enable
profiling.
.TP
\fB::profiler::resume\fR ?\fIpattern\fR?\fR
Resume profiling for all functions matching \fIpattern\fR.  If no
pattern is specified, profiling will be resumed for all functions.
This command should be invoked after suspending the profiler in the
code.
.TP
\fB::profiler::sortFunctions\fR \fIkey\fR\fR
Return a list of functions sorted by a particular profiling statistic.
Supported values for \fIkey\fR are: \fBcalls\fR,
\fBexclusiveTime\fR, \fBcompileTime\fR, \fBnonCompileTime\fR,
\fBtotalRuntime\fR, \fBavgExclusiveTime\fR, and
\fBavgRuntime\fR.  The return result is a list of lists, where each
sublist consists of a function name and the value of \fIkey\fR for
that function.
.SH "KEYWORDS"
profile, performance, speed
