'\" -*- tcl -*- doctools manpage
'\"
'\" Generated from ../tcllib/modules/math/math.man by mpexpand with fmt.nroff
'\"
.so man.macros
.TH "math" n 4.2 math "Tcl Math Library"
.BS
.SH NAME
math \- Tcl Math Library
.SH "SYNOPSIS"
package require \fBTcl 8.2\fR
.sp
package require \fBmath ?1.2?\fR
.sp
\fB::math::cov\fR \fIvalue\fR \fIvalue\fR ?\fIvalue ...\fR?\fR
.sp
\fB::math::integrate\fR \fIlist of xy value pairs\fR\fR
.sp
\fB::math::fibonacci\fR \fIn\fR\fR
.sp
\fB::math::max\fR \fIvalue\fR ?\fIvalue ...\fR?\fR
.sp
\fB::math::mean\fR \fIvalue\fR ?\fIvalue ...\fR?\fR
.sp
\fB::math::min\fR \fIvalue\fR ?\fIvalue ...\fR?\fR
.sp
\fB::math::prod\fR \fIvalue\fR ?\fIvalue ...\fR?\fR
.sp
\fB::math::random\fR ?\fIvalue1\fR? ?\fIvalue2\fR?\fR
.sp
\fB::math::sigma\fR \fIvalue\fR \fIvalue\fR ?\fIvalue ...\fR?\fR
.sp
\fB::math::stats\fR \fIvalue\fR \fIvalue\fR ?\fIvalue ...\fR?\fR
.sp
\fB::math::sum\fR \fIvalue\fR ?\fIvalue ...\fR?\fR
.sp
.BE
.SH "DESCRIPTION"
.PP
The \fBmath\fR package provides utility math functions.
.SH "COMMANDS"
.TP
\fB::math::cov\fR \fIvalue\fR \fIvalue\fR ?\fIvalue ...\fR?\fR
Return the coefficient of variation expressed as percent of two or
more numeric values.
.TP
\fB::math::integrate\fR \fIlist of xy value pairs\fR\fR
Return the area under a "curve" defined by a set of x,y pairs and the
error bound as a list.
.TP
\fB::math::fibonacci\fR \fIn\fR\fR
Return the \fIn\fR'th Fibonacci number.
.TP
\fB::math::max\fR \fIvalue\fR ?\fIvalue ...\fR?\fR
Return the maximum of one or more numeric values.
.TP
\fB::math::mean\fR \fIvalue\fR ?\fIvalue ...\fR?\fR
Return the mean, or "average" of one or more numeric values.
.TP
\fB::math::min\fR \fIvalue\fR ?\fIvalue ...\fR?\fR
Return the minimum of one or more numeric values.
.TP
\fB::math::prod\fR \fIvalue\fR ?\fIvalue ...\fR?\fR
Return the product of one or more numeric values.
.TP
\fB::math::random\fR ?\fIvalue1\fR? ?\fIvalue2\fR?\fR
Return a random number.  If no arguments are given, the number is a
floating point value between 0 and 1.  If one argument is given, the
number is an integer value between 0 and \fIvalue1\fR.  If two
arguments are given, the number is an integer value between
\fIvalue1\fR and \fIvalue2\fR.
.TP
\fB::math::sigma\fR \fIvalue\fR \fIvalue\fR ?\fIvalue ...\fR?\fR
Return the population standard deviation of two or more numeric
values.
.TP
\fB::math::stats\fR \fIvalue\fR \fIvalue\fR ?\fIvalue ...\fR?\fR
Return the mean, standard deviation, and coefficient of variation as
percent as a list.
.TP
\fB::math::sum\fR \fIvalue\fR ?\fIvalue ...\fR?\fR
Return the sum of one or more numeric values.
.SH "KEYWORDS"
math, statistics
