/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.util.Vector;
import tcl.lang.CmdTraceProc;
import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclIndex;
import tcl.lang.TclList;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclString;
import tcl.lang.TraceRecord;
import tcl.lang.VarTrace;

class TraceCmd
implements Command {
    private static final String[] validCmds = new String[]{"variable", "vdelete", "vinfo"};
    private static final int OPT_VARIABLE = 0;
    private static final int OPT_VDELETE = 1;
    private static final int OPT_VINFO = 2;
    private static TclObject[] opStr = TraceCmd.initOptStr();

    private static TclObject[] initOptStr() {
        TclObject[] strings = new TclObject[]{TclString.newInstance((String)"error"), TclString.newInstance((String)"r"), TclString.newInstance((String)"w"), TclString.newInstance((String)"rw"), TclString.newInstance((String)"u"), TclString.newInstance((String)"ru"), TclString.newInstance((String)"wu"), TclString.newInstance((String)"rwu")};
        int i = 0;
        while (i < 8) {
            strings[i].preserve();
            ++i;
        }
        return strings;
    }

    public void cmdProc(Interp interp, TclObject[] argv) throws TclException {
        if (argv.length < 2) {
            throw new TclNumArgsException(interp, 1, argv, "option arg ?arg ...?");
        }
        int opt = TclIndex.get((Interp)interp, (TclObject)argv[1], (String[])validCmds, (String)"option", (int)0);
        block1 : switch (opt) {
            case 0: 
            case 1: {
                if (argv.length != 5) {
                    if (opt == 0) {
                        throw new TclNumArgsException(interp, 1, argv, "variable name ops command");
                    }
                    throw new TclNumArgsException(interp, 1, argv, "vdelete name ops command");
                }
                int flags = 0;
                String ops = argv[3].toString();
                int len = ops.length();
                int i = 0;
                block12: while (i < len) {
                    switch (ops.charAt(i)) {
                        case 'r': {
                            flags |= 0x10;
                            break;
                        }
                        case 'w': {
                            flags |= 0x20;
                            break;
                        }
                        case 'u': {
                            flags |= 0x40;
                            break;
                        }
                        default: {
                            flags = 0;
                            break block12;
                        }
                    }
                    ++i;
                }
                if (flags == 0) {
                    throw new TclException(interp, "bad operations \"" + argv[3] + "\": should be one or more of rwu");
                }
                if (opt == 0) {
                    CmdTraceProc trace = new CmdTraceProc(argv[4].toString(), flags);
                    interp.varFrame.traceVar(argv[2], (VarTrace)trace, flags);
                    break;
                }
                Vector traces = interp.varFrame.getTraces(argv[2], 0);
                if (traces == null) break;
                len = traces.size();
                int i2 = 0;
                while (i2 < len) {
                    TraceRecord rec = (TraceRecord)traces.elementAt(i2);
                    if (rec.trace instanceof CmdTraceProc) {
                        CmdTraceProc proc = (CmdTraceProc)rec.trace;
                        if (proc.flags == flags && proc.command.toString().equals(argv[4].toString())) {
                            interp.varFrame.untraceVar(argv[2], (VarTrace)proc, flags);
                            break block1;
                        }
                    }
                    ++i2;
                }
                break;
            }
            case 2: {
                if (argv.length != 3) {
                    throw new TclNumArgsException(interp, 2, argv, "name");
                }
                Vector traces = interp.varFrame.getTraces(argv[2], 0);
                if (traces == null) break;
                int len = traces.size();
                TclObject list = TclList.newInstance();
                TclObject cmd = null;
                list.preserve();
                try {
                    int i = 0;
                    while (i < len) {
                        TraceRecord rec = (TraceRecord)traces.elementAt(i);
                        if (rec.trace instanceof CmdTraceProc) {
                            CmdTraceProc proc = (CmdTraceProc)rec.trace;
                            int mode = proc.flags;
                            mode &= 0x70;
                            cmd = TclList.newInstance();
                            TclList.append(interp, cmd, opStr[mode /= 16]);
                            TclList.append(interp, cmd, TclString.newInstance((String)proc.command));
                            TclList.append(interp, list, cmd);
                        }
                        ++i;
                    }
                    interp.setResult(list);
                    break;
                }
                finally {
                    Object var11_22 = null;
                    list.release();
                }
            }
        }
    }

    TraceCmd() {
    }
}

