/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import tcl.lang.CObject;
import tcl.lang.InternalRep;
import tcl.lang.TclRuntimeError;
import tcl.lang.TclString;

public final class TclObject {
    protected InternalRep internalRep;
    protected int refCount;
    protected String stringRep;

    public TclObject(InternalRep internalRep) {
        this.internalRep = internalRep;
        this.stringRep = null;
        this.refCount = 0;
    }

    protected TclObject(TclString tclString, String string) {
        this.internalRep = tclString;
        this.stringRep = string;
        this.refCount = 0;
    }

    public final InternalRep getInternalRep() {
        return this.internalRep;
    }

    public final void setInternalRep(InternalRep internalRep) {
        if (internalRep == this.internalRep) {
            return;
        }
        if (this.internalRep instanceof CObject && !(internalRep instanceof CObject)) {
            if (this.stringRep == null) {
                this.stringRep = this.internalRep.toString();
            }
            ((CObject)this.internalRep).makeReference(this);
        }
        this.internalRep.dispose();
        this.internalRep = internalRep;
    }

    public final String toString() {
        if (this.stringRep == null) {
            this.stringRep = this.internalRep.toString();
        }
        return this.stringRep;
    }

    public final void invalidateStringRep() throws TclRuntimeError {
        if (this.refCount > 1) {
            throw new TclRuntimeError("string representation of object \"" + this.toString() + "\" cannot be invalidated: refCount = " + this.refCount);
        }
        this.stringRep = null;
    }

    public final boolean isShared() {
        return this.refCount > 1;
    }

    public final TclObject takeExclusive() throws TclRuntimeError {
        if (this.refCount == 1) {
            return this;
        }
        if (this.refCount > 1) {
            if (this.internalRep instanceof TclString && this.stringRep == null) {
                this.stringRep = this.internalRep.toString();
            }
            TclObject tclObject = new TclObject(this.internalRep.duplicate());
            tclObject.stringRep = this.stringRep;
            tclObject.refCount = 1;
            --this.refCount;
            return tclObject;
        }
        throw new TclRuntimeError("takeExclusive() called on object \"" + this.toString() + "\" with: refCount = 0");
    }

    public final void preserve() throws TclRuntimeError {
        if (this.internalRep == null) {
            throw new TclRuntimeError("Attempting to preserve object after it was deallocated");
        }
        ++this.refCount;
    }

    public final void release() {
        --this.refCount;
        if (this.refCount <= 0) {
            this.internalRep.dispose();
            this.internalRep = null;
            this.stringRep = null;
        }
    }

    protected final int getRefCount() {
        return this.refCount;
    }
}

