/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import tcl.lang.AssocData;
import tcl.lang.Command;
import tcl.lang.Notifier;
import tcl.lang.TclBoolean;
import tcl.lang.TclDouble;
import tcl.lang.TclException;
import tcl.lang.TclInteger;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;
import tcl.lang.TclString;
import tcl.lang.Util;
import tcl.lang.VarTrace;

public class Interp {
    long interpPtr;
    Hashtable reflectIDTable = new Hashtable();
    Hashtable reflectObjTable = new Hashtable();
    long reflectObjCount = 0L;
    private Notifier notifier;
    Hashtable assocDataTab;
    Hashtable[] importTable = new Hashtable[]{new Hashtable(), new Hashtable()};

    static {
        try {
            System.loadLibrary("tclblend");
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            System.out.println("System.loadLibrary(\"tclblend\") failed because of UnsatisfiedLinkError");
            unsatisfiedLinkError.printStackTrace(System.out);
        }
        catch (Throwable throwable) {
            System.out.println("System.loadLibrary(\"tclblend\") failed because of Unknown Throwable");
            throwable.printStackTrace(System.out);
        }
    }

    public Interp() {
        this.interpPtr = this.create();
        this.notifier = Notifier.getNotifierForThread(Thread.currentThread());
        this.notifier.preserve();
        if (this.init(this.interpPtr) != 0) {
            String string = this.getResult().toString();
            this.dispose();
            throw new TclRuntimeError(string);
        }
    }

    private Interp(long l) {
        this.interpPtr = l;
        this.notifier = Notifier.getNotifierForThread(Thread.currentThread());
        this.notifier.preserve();
    }

    public native void addErrorInfo(String var1);

    public native void backgroundError();

    private int callCommand(Command command, TclObject[] tclObjectArray) {
        try {
            command.cmdProc(this, tclObjectArray);
            return 0;
        }
        catch (TclException tclException) {
            return tclException.getCompletionCode();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw new TclRuntimeError("Error in command implementation");
        }
    }

    private void closeInputStream(InputStream inputStream) {
        try {
            inputStream.close();
        }
        catch (IOException iOException) {}
    }

    public static native boolean commandComplete(String var0);

    private final native long create();

    public native void createCommand(String var1, Command var2);

    public void deleteAssocData(String string) {
        if (this.assocDataTab == null) {
            return;
        }
        this.assocDataTab.remove(string);
    }

    public native int deleteCommand(String var1);

    public void dispose() {
        if (this.assocDataTab != null) {
            Enumeration enumeration = this.assocDataTab.keys();
            while (enumeration.hasMoreElements()) {
                Object k = enumeration.nextElement();
                AssocData assocData = (AssocData)this.assocDataTab.get(k);
                assocData.disposeAssocData(this);
                this.assocDataTab.remove(k);
            }
            this.assocDataTab = null;
        }
        if (this.notifier != null) {
            this.notifier.release();
            this.notifier = null;
        }
        if (this.interpPtr != 0L) {
            Interp.doDispose(this.interpPtr);
            this.interpPtr = 0L;
        }
    }

    private static final native void doDispose(long var0);

    public void eval(String string) throws TclException {
        this.eval(string, 0);
    }

    public native void eval(String var1, int var2) throws TclException;

    public void eval(TclObject tclObject, int n) throws TclException {
        this.eval(tclObject.toString(), n);
    }

    public void evalFile(String string) throws TclException {
        throw new TclRuntimeError("Not implemented yet.");
    }

    void evalResource(String string) throws TclException {
        InputStream inputStream = this.getClass().getResourceAsStream(string);
        if (inputStream == null) {
            throw new TclException(this, "cannot read resource \"" + string + "\"");
        }
        try {
            try {
                if (System.getProperty("java.version").startsWith("1.2") && inputStream.getClass().getName().equals("java.util.zip.ZipFile$1")) {
                    int n;
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
                    byte[] byArray = new byte[1024];
                    while ((n = inputStream.read(byArray, 0, byArray.length)) != -1) {
                        byteArrayOutputStream.write(byArray, 0, n);
                    }
                    this.eval(new String(byteArrayOutputStream.toByteArray()), 0);
                } else {
                    int n = inputStream.available();
                    byte[] byArray = new byte[n];
                    int n2 = 0;
                    while (n > 0) {
                        int n3 = inputStream.read(byArray, n2, n);
                        n2 += n3;
                        n -= n3;
                    }
                    this.eval(new String(byArray), 0);
                }
            }
            catch (IOException iOException) {
                Object var4_10 = null;
                this.closeInputStream(inputStream);
                return;
            }
            Object var4_11 = null;
            this.closeInputStream(inputStream);
        }
        catch (Throwable throwable) {
            Object var4_12 = null;
            this.closeInputStream(inputStream);
            throw throwable;
        }
    }

    protected void finalize() {
        this.dispose();
    }

    public AssocData getAssocData(String string) {
        if (this.assocDataTab == null) {
            return null;
        }
        return (AssocData)this.assocDataTab.get(string);
    }

    public Command getCommand(String string) {
        throw new TclRuntimeError("Not implemented yet.");
    }

    public Notifier getNotifier() {
        return this.notifier;
    }

    public final native TclObject getResult();

    public final TclObject getVar(String string, int n) throws TclException {
        return this.getVar(string, null, n | 0x400);
    }

    public final native TclObject getVar(String var1, String var2, int var3) throws TclException;

    File getWorkingDir() {
        return new File(Util.getCwd());
    }

    private final native int init(long var1);

    public final native void pkgProvide(String var1, String var2);

    public final native String pkgRequire(String var1, String var2, boolean var3);

    public final native void resetResult();

    public void setAssocData(String string, AssocData assocData) {
        if (this.assocDataTab == null) {
            this.assocDataTab = new Hashtable();
        }
        this.assocDataTab.put(string, assocData);
    }

    public native void setErrorCode(TclObject var1);

    public final void setResult(double d) {
        this.setResult(TclDouble.newInstance((double)d));
    }

    public final void setResult(int n) {
        this.setResult(TclInteger.newInstance((int)n));
    }

    public final void setResult(String string) {
        this.setResult(TclString.newInstance((String)string));
    }

    public final native void setResult(TclObject var1);

    public final void setResult(boolean bl) {
        this.setResult(TclBoolean.newInstance((boolean)bl));
    }

    public final native TclObject setVar(String var1, String var2, TclObject var3, int var4) throws TclException;

    public final TclObject setVar(String string, TclObject tclObject, int n) throws TclException {
        return this.setVar(string, null, tclObject, n | 0x400);
    }

    public native void traceVar(String var1, String var2, VarTrace var3, int var4) throws TclException;

    public void traceVar(String string, VarTrace varTrace, int n) throws TclException {
        this.traceVar(string, null, varTrace, n | 0x400);
    }

    public final void unsetVar(String string, int n) throws TclException {
        this.unsetVar(string, null, n | 0x400);
    }

    public final native void unsetVar(String var1, String var2, int var3) throws TclException;

    public native void untraceVar(String var1, String var2, VarTrace var3, int var4) throws TclException;

    public void untraceVar(String string, VarTrace varTrace, int n) throws TclException {
        this.untraceVar(string, null, varTrace, n | 0x400);
    }
}

