/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import tcl.lang.EventDeleter;
import tcl.lang.TclEvent;
import tcl.lang.TclRuntimeError;

public class Notifier {
    private static Notifier globalNotifier;
    private TclEvent firstEvent;
    private TclEvent lastEvent;
    private TclEvent markerEvent;
    Thread primaryThread;
    int refCount;

    private Notifier(Thread thread) {
        this.primaryThread = thread;
        this.firstEvent = null;
        this.lastEvent = null;
        this.markerEvent = null;
        this.refCount = 0;
        this.init();
    }

    private final native void alertNotifier();

    public synchronized void deleteEvents(EventDeleter eventDeleter) {
        TclEvent tclEvent = null;
        TclEvent tclEvent2 = this.firstEvent;
        while (tclEvent2 != null) {
            if (eventDeleter.deleteEvent(tclEvent2) == 1) {
                if (this.firstEvent == tclEvent2) {
                    this.firstEvent = tclEvent2.next;
                    if (tclEvent2.next == null) {
                        this.lastEvent = null;
                    }
                } else {
                    tclEvent.next = tclEvent2.next;
                }
                if (this.markerEvent == tclEvent2) {
                    this.markerEvent = null;
                }
            } else {
                tclEvent = tclEvent2;
            }
            tclEvent2 = tclEvent2.next;
        }
    }

    final native void dispose();

    public native int doOneEvent(int var1);

    public static synchronized Notifier getNotifierForThread(Thread thread) {
        if (globalNotifier == null) {
            globalNotifier = new Notifier(thread);
        } else if (Notifier.globalNotifier.primaryThread != thread) {
            return null;
        }
        return globalNotifier;
    }

    private final synchronized boolean hasEvents() {
        return this.firstEvent != null;
    }

    private final native void init();

    public synchronized void preserve() {
        if (this.refCount < 0) {
            throw new TclRuntimeError("Attempting to preserve a freed Notifier");
        }
        ++this.refCount;
    }

    public synchronized void queueEvent(TclEvent tclEvent, int n) {
        tclEvent.notifier = this;
        if (n == 0) {
            tclEvent.next = null;
            if (this.firstEvent == null) {
                this.firstEvent = tclEvent;
            } else {
                this.lastEvent.next = tclEvent;
            }
            this.lastEvent = tclEvent;
        } else if (n == 1) {
            tclEvent.next = this.firstEvent;
            if (this.firstEvent == null) {
                this.lastEvent = tclEvent;
            }
            this.firstEvent = tclEvent;
        } else if (n == 2) {
            if (this.markerEvent == null) {
                tclEvent.next = this.firstEvent;
                this.firstEvent = tclEvent;
            } else {
                tclEvent.next = this.markerEvent.next;
                this.markerEvent.next = tclEvent;
            }
            this.markerEvent = tclEvent;
            if (tclEvent.next == null) {
                this.lastEvent = tclEvent;
            }
        } else {
            throw new TclRuntimeError("wrong position \"" + n + "\", must be TCL.QUEUE_HEAD, TCL.QUEUE_TAIL or TCL.QUEUE_MARK");
        }
        if (Thread.currentThread() != this.primaryThread) {
            this.alertNotifier();
        }
    }

    public synchronized void release() {
        if (this.refCount == 0 && this.primaryThread != null) {
            throw new TclRuntimeError("Attempting to release a Notifier before it's preserved");
        }
        if (this.refCount <= 0) {
            throw new TclRuntimeError("Attempting to release a freed Notifier");
        }
        --this.refCount;
        if (this.refCount == 0) {
            this.primaryThread = null;
            globalNotifier = null;
            this.dispose();
        }
    }

    synchronized int serviceEvent(int n) {
        if ((n & 0xFFFFFFFD) == 0) {
            n |= 0xFFFFFFFD;
        }
        TclEvent tclEvent = this.firstEvent;
        while (tclEvent != null) {
            boolean bl = tclEvent.isProcessing;
            tclEvent.isProcessing = true;
            if (!bl && tclEvent.processEvent(n) != 0) {
                tclEvent.isProcessed = true;
                if (tclEvent.needsNotify) {
                    TclEvent tclEvent2 = tclEvent;
                    synchronized (tclEvent2) {
                        tclEvent.notifyAll();
                    }
                }
                if (this.firstEvent == tclEvent) {
                    this.firstEvent = tclEvent.next;
                    if (tclEvent.next == null) {
                        this.lastEvent = null;
                    }
                    if (this.markerEvent == tclEvent) {
                        this.markerEvent = null;
                    }
                } else {
                    TclEvent tclEvent3 = this.firstEvent;
                    while (tclEvent3.next != tclEvent) {
                        tclEvent3 = tclEvent3.next;
                    }
                    tclEvent3.next = tclEvent.next;
                    if (tclEvent.next == null) {
                        this.lastEvent = tclEvent3;
                    }
                    if (this.markerEvent == tclEvent) {
                        this.markerEvent = tclEvent3;
                    }
                }
                return 1;
            }
            tclEvent.isProcessing = bl;
            tclEvent = tclEvent.next;
        }
        return 0;
    }
}

