/*
 * Decompiled with CFR 0.152.
 */
package com.e4graph;

import com.e4graph.NoSuchNodeException;
import com.e4graph.Node;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class ParentIterator
implements Iterator {
    private Node parent = null;
    private Node node = null;
    private int index = -1;

    public ParentIterator(Node node) {
        this.node = node;
        try {
            this.parent = this.node.parent();
        }
        catch (NoSuchNodeException noSuchNodeException) {
            this.parent = null;
        }
    }

    public void remove() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("remove() not supported");
    }

    public boolean hasNext() {
        if (this.parent == null) {
            return false;
        }
        return this.index < this.node.parentCount();
    }

    public Object next() throws NoSuchElementException {
        if (this.parent == null) {
            throw new NoSuchElementException("node has no parents");
        }
        if (this.index < this.node.parentCount()) {
            ++this.index;
            try {
                this.parent = this.node.parent(this.index);
            }
            catch (NoSuchNodeException noSuchNodeException) {
                throw new NoSuchElementException("no next parent");
            }
            return this.parent;
        }
        throw new NoSuchElementException("no next parent");
    }
}

