/*
 * t4intrep.cpp --
 *
 *	This file contains the implementation of the class T4InternalRep
 *	which is defined in .../include/t4graphrep.h.
 *
 *	Authors: Jacob Levy and Jean-Claude Wippler.
 *		 jyl@best.com	jcw@equi4.com
 *
 * Copyright (c) 2000-2003, JYL Software Inc.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 * 
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE, EVEN IF
 * JYL SOFTWARE INC. IS MADE AWARE OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "t4graphrep.h"

/*
 * Default constructor:
 */

T4InternalRep::T4InternalRep()
{
    /*
     * Must initialize the fields to NULL explicitly because VC++ 6.0
     * in debug mode initializes them to garbage instead of NULL.
     */

    nm = NULL;
    nmlen = 0;

    /*
     * The Tcl_Obj associated with this internal representation is NULL
     * initially.
     */

    tclPtr = NULL;
}

/*
 * GetName --
 *
 * 	Returns the name of this T4Graph object. The name is used to store
 *	the name by which the object is known to Tcl.
 */

char *
T4InternalRep::GetName()
{
    char *ksp;

    if (nm == NULL) {
	ksp = (char *) KindString();
	nmlen = strlen(ksp) + 32;
	nm = (char *) Tcl_Alloc(nmlen);
	sprintf(nm, "%s0x%x", ksp, this);
	nmlen = strlen(nm);
    }
    return nm;
}

/*
 * GetNameLen --
 *
 *	Returns the length of the name of this T4Graph object.
 */

int
T4InternalRep::GetNameLen()
{
   return nmlen;
}

/*
 * KindIdentifier --
 *
 *	Returns the identifier that denotes which type of class derived
 *	from T4InternalRep this instance really is. This method should be
 *	overridden by all classes derived from T4InternalRep.
 */

T4Kinds
T4InternalRep::KindIdentifier() const
{
    return T4GRAPH_ILLEGAL;
}

/*
 * KindString --
 *
 *	Returns the string name of the identifier that denotes which type of
 *	class derived from T4InternalRep this instance really is. This method
 *	should be overridden by all classes derived from T4InternalRep.
 */

const char *
T4InternalRep::KindString() const
{
    return "IllegalInternalRep";
}

/*
 * Retrieve the Tcl_Obj * associated with this internal representation.
 */

Tcl_Obj *
T4InternalRep::GetTclObject()
{
    return tclPtr;
}

/*
 * Associate a (possibly new) Tcl_Obj * with this internal representation.
 */

void
T4InternalRep::SetTclObject(Tcl_Obj *obj)
{
    tclPtr = obj;
}
