/*****************************************************************************
 *
 *  File: oprintf.c
 *  sprintf-like routines for Tcl objects.
 *
 *****************************************************************************
 *
 *  Copyright (c) 2000 David Cuthbert / Kanga International Group.
 *  All rights reserved.
 *
 *  Permission to use, copy, modify, distribute and sell this software
 *  and its documentation for any purpose is hereby granted without fee,
 *  provided that the above copyright notice appear in all copies and
 *  that both that copyright notice and this permission notice appear
 *  in supporting documentation.  The author(s) make no representations
 *  about the suitability of this software for any purpose.  It is 
 *  provided "as is" without express or implied warranty.
 *
 *****************************************************************************/

#include <tcl.h>
#include <stdarg.h>
#include <stdlib.h>
#include <stdio.h>
#include "kt2c_platform.h"

int oappendf(Tcl_Obj *obj, char const *format, ...)
{
    va_list args;
    int     result;
    char    temp1[256];
    char   *temp2;

    va_start(args, format);

    result = vsnprintf(temp1, 256, format, args);
    if(result < 256) {
	Tcl_AppendToObj(obj, temp1, result);
    } else {
	/* Try again with a buffer that is large enough. */
	temp2 = (char *)malloc(result + 1);
	result = vsprintf(temp2, format, args);
	Tcl_AppendToObj(obj, temp2, result);
	free(temp2);
    }

    va_end(args);
    return result;
}


int oprintf(Tcl_Obj *obj, char const *format, ...)
{
    va_list args;
    int     result;
    char    temp1[256];
    char   *temp2;

    va_start(args, format);

    result = vsnprintf(temp1, 256, format, args);
    if(result < 256) {
	Tcl_SetStringObj(obj, temp1, result);
    } else {
	/* Try again with a buffer that is large enough. */
	temp2 = (char *)malloc(result + 1);
	result = vsprintf(temp2, format, args);
	Tcl_SetStringObj(obj, temp2, result);
	free(temp2);
    }

    va_end(args);
    return result;
}

