##############################################################################
#
#   File: pkgIndex.tcl
#   Tcl 8.x package index file for Kanga Tcl-to-C.
#
##############################################################################
#
#   Copyright (c) 2000 David Cuthbert / Kanga International Group.
#   All rights reserved.
#
#   Permission to use, copy, modify, distribute and sell this software
#   and its documentation for any purpose is hereby granted without fee,
#   provided that the above copyright notice appear in all copies and
#   that both that copyright notice and this permission notice appear
#   in supporting documentation.  The author(s) make no representations
#   about the suitability of this software for any purpose.  It is 
#   provided "as is" without express or implied warranty.
#
##############################################################################

namespace eval ::kt2c {
    variable Version 0.2
    variable LibraryDirectory
    variable Prefix
    variable Library

    set LibraryDirectory [file dirname [info script]]
    set old_wd [pwd]
    cd $LibraryDirectory
    set LibraryDirectory [pwd]
    
    # Prefix should be up two levels
    cd ..
    cd ..
    set Prefix [pwd]

    cd $old_wd
    unset old_wd

    if {[string equal $::tcl_platform(platform) unix]} {
	set library_prefix lib
	set library_suffixes [list -g.so.${Version} .so.${Version}]
    } elseif {[string equal $::tcl_platform(platform) windows]} {
	set library_prefix ""
	set library_suffixes [list ${Version}g.dll ${Version}.dll]
    }

    foreach s $library_suffixes {
	if {[file exists \
		 [file join $LibraryDirectory ${library_prefix}kt2c$s]]} {
	    set Library [file join $LibraryDirectory ${library_prefix}kt2c$s]
	    break
	}
    }

    if {[info exists library_prefix]} { unset library_prefix }
    if {[info exists library_suffix]} { unset library_suffix }
}


package ifneeded kt2c ${::kt2c::Version} {
    namespace eval ::kt2c {
	if {![info exists Library]} {
	    if {[string equal $tcl_platform(platform) unix]} {
		error "library libkt2c.so.${Version} not found."
	    } else {
		error "library kt2c${Version}.dll not found."
	    }
	}

	set old_wd [pwd]
	cd $LibraryDirectory
	set retval [catch { load $Library Kt2c } cmsg]
	cd $old_wd
	unset old_wd

	if {$retval != 0} { error $cmsg }

	source [file join $LibraryDirectory kt2c_utils.tcl]
    }
}

