[comment {-*- tcl -*-}]
[manpage_begin csv n 0.6]
[copyright {2002-2005 Andreas Kupries <andreas_kupries@users.sourceforge.net>}]
[moddesc   {CSV processing}]
[titledesc {Procedures to handle CSV data.}]
[require Tcl 8.3]
[require csv [opt 0.6]]
[description]

[para]

The [package csv] package provides commands to manipulate information
in CSV [sectref FORMAT] (CSV = Comma Separated Values).

[section COMMANDS]
[para]

The following commands are available:

[list_begin definitions]

[call [cmd ::csv::join] [arg values] "{[arg sepChar] ,}"]

Takes a list of values and returns a string in CSV format containing
these values. The separator character can be defined by the caller,
but this is optional. The default is ",".

[call [cmd ::csv::joinlist] [arg values] "{[arg sepChar] ,}"]

Takes a list of lists of values and returns a string in CSV format
containing these values. The separator character can be defined by the
caller, but this is optional. The default is ",". Each element of the
outer list is considered a record, these are separated by newlines in
the result. The elements of each record are formatted as usual (via
[cmd ::csv::join]).

[call [cmd ::csv::joinmatrix] [arg matrix] "{[arg sepChar] ,}"]

Takes a [arg matrix] object following the API specified for the
struct::matrix package and returns a string in CSV format containing
these values. The separator character can be defined by the caller,
but this is optional. The default is ",". Each row of the matrix is
considered a record, these are separated by newlines in the
result. The elements of each record are formatted as usual (via
[cmd ::csv::join]).

[call [cmd ::csv::read2matrix] [opt [option -alternate]] [arg "chan m"] "{[arg sepChar] ,} {[arg expand] none}"]

A wrapper around [cmd ::csv::split2matrix] (see below) reading
CSV-formatted lines from the specified channel (until EOF) and adding
them to the given matrix. For an explanation of the [arg expand]
argument see [cmd ::csv::split2matrix].

[call [cmd ::csv::read2queue] [opt [option -alternate]] [arg "chan q"] "{[arg sepChar] ,}"]

A wrapper around [cmd ::csv::split2queue] (see below) reading
CSV-formatted lines from the specified channel (until EOF) and adding
them to the given queue.

[call [cmd ::csv::report] [arg "cmd matrix"] [opt [arg chan]]]

A report command which can be used by the matrix methods

[cmd "format 2string"] and [cmd "format 2chan"]. For the latter this
command delegates the work to [cmd ::csv::writematrix]. [arg cmd] is
expected to be either [method printmatrix] or

[method printmatrix2channel]. The channel argument, [arg chan], has
to be present for the latter and must not be present for the first.

[call [cmd ::csv::split] [opt [option -alternate]] [arg line] "{[arg sepChar] ,}"]

converts a [arg line] in CSV format into a list of the values
contained in the line. The character used to separate the values from
each other can be defined by the caller, via [arg sepChar], but this
is optional. The default is ",".

[nl]

If the option [option -alternate] is spcified a slightly different
syntax is used to parse the input. This syntax is explained below, in
the section [sectref FORMAT].


[call [cmd ::csv::split2matrix] [opt [option -alternate]] [arg "m line"] "{[arg sepChar] ,} {[arg expand] none}"]

The same as [cmd ::csv::split], but appends the resulting list as a
new row to the matrix [arg m], using the method [cmd "add row"]. The
expansion mode specified via [arg expand] determines how the command
handles a matrix with less columns than contained in [arg line]. The
allowed modes are:

[list_begin definitions]

[lst_item [const none]]

This is the default mode. In this mode it is the responsibility of the
caller to ensure that the matrix has enough columns to contain the
full line. If there are not enough columns the list of values is
silently truncated at the end to fit.

[lst_item [const empty]]

In this mode the command expands an empty matrix to hold all columns
of the specified line, but goes no further. The overall effect is that
the first of a series of lines determines the number of columns in the
matrix and all following lines are truncated to that size, as if mode
[const none] was set.

[lst_item [const auto]]

In this mode the command expands the matrix as needed to hold all
columns contained in [arg line]. The overall effect is that after
adding a series of lines the matrix will have enough columns to hold
all columns of the longest line encountered so far.

[list_end]

[call [cmd ::csv::split2queue] [opt [option -alternate]] [arg "q line"] "{[arg sepChar] ,}"]

The same as [cmd ::csv::split], but appending the resulting list as a
single item to the queue [arg q], using the method [cmd put].

[call [cmd ::csv::writematrix] [arg "m chan"] "{[arg sepChar] ,}"]

A wrapper around [cmd ::csv::join] taking all rows in the matrix
[arg m] and writing them CSV formatted into the channel [arg chan].

[call [cmd ::csv::writequeue] [arg "q chan"] "{[arg sepChar] ,}"]

A wrapper around [cmd ::csv::join] taking all items in the queue
[arg q] (assumes that they are lists) and writing them CSV formatted
into the channel [arg chan].

[list_end]

[section FORMAT]
[para]

The format of regular CSV files is specified as 

[list_begin enum]

[enum]
Each record of a csv file (comma-separated values, as exported e.g. by
Excel) is a set of ASCII values separated by ",". For other languages
it may be ";" however, although this is not important for this case as
the functions provided here allow any separator character.

[enum]
If and only if a value contains itself the separator ",", then it (the
value) has to be put between "". If the value does not contain the
separator character then quoting is optional.

[enum]
If a value contains the character ", that character is represented by "".

[enum]
The output string "" represents the value ". In other words, it is
assumed that it was created through rule 3, and only this rule,
i.e. that the value was not quoted.

[list_end]
[para]

An alternate format definition mainly used by MS products specifies
that the output string "" is an representatation of the empty
string. In other words, it is assumed that the output was generated
out of the empty string by quoting it (i.e. rule 2), and not through
rule 3. This is the only difference between the regular and the
alternate format.

[para]

The alternate format is activated through specification of the option
[option -alternate] to the various split commands.

[section EXAMPLE]

Using the regular format the record

[para]
[example {
123,"123,521.2","Mary says ""Hello, I am Mary""",""
}]

[para]
is parsed into the items

[para]
[example {
a) 123
b) 123,521.2
c) Mary says "Hello, I am Mary"
d) (the empty string)
}]
[para]

Using the alternate format the result is

[para]
[example {
a) 123
b) 123,521.2
c) Mary says "Hello, I am Mary"
d) "
}]

instead. As can be seen only item (d) is different, now a " instead of
the empty string.


[see_also matrix queue]
[keywords csv matrix queue package tcllib]
[manpage_end]
