#include <tkgs.h>
#include <tkgsInt.h>

#include "tkgsWin.h"
#include "tkgsWinInt.h"

#include <tkWinInt.h>

/*
 * Prototypes for procedures defined later in this file:
 */

/* Driver */

static TkGS_GetDrawableProc		WinTkGS_GetDrawable;

static TkGSUpdateDrawableStateProc	WinTkGSUpdateDrawableState;

static TkGS_DrawRectangleProc		WinTkGS_DrawRectangle;
static TkGS_DrawRectanglesProc		WinTkGS_DrawRectangles;
static TkGS_FillRectangleProc		WinTkGS_FillRectangle;
static TkGS_FillRectanglesProc		WinTkGS_FillRectangles;
static TkGS_DrawEllipseProc		WinTkGS_DrawEllipse;
static TkGS_DrawEllipsesProc		WinTkGS_DrawEllipses;



/*
 * Driver
 */

TkGS_DeviceDriver WinDeviceDriver = {
    "Win32",

    WinTkGS_GetDrawable,

    WinTkGSUpdateDrawableState,

    /* Line & shape primitives */
    WinTkGS_DrawRectangle,
    WinTkGS_DrawRectangles,
    WinTkGS_FillRectangle,
    WinTkGS_FillRectangles,
    WinTkGS_DrawEllipse,
    WinTkGS_DrawEllipses,

    /* Fonts and text primitives: */
    WinTkGS_GetFontMetrics,
    WinTkGS_GetActualFontAttributes,
    NULL, /* enumerateFontFamilies, initialized at runtime. */
    NULL, /* fontFamilyExists, ditto. */

    /*  - Unicode */
    WinTkGS_MeasureCharsUni,
    NULL,
    WinTkGS_DrawCharsUni,
    NULL,

    /*  - UTF-8 */
    WinTkGS_MeasureCharsUtf,
    NULL,
    WinTkGS_DrawCharsUtf,
    NULL,

    /*  - System-specific */
    NULL,
    WinTkGS_TextWidthSys,
    WinTkGS_DrawCharsSys,
    NULL,

    /*  - Multi-font Unicode system */
    1,					/* Non-native Unicode */
    0,					/* Face name uniquely identifies font 
					 * family. */
    WinTkGSGetSubFont,
    WinTkGSSetDrawableSubFont,
    WinTkGSFontMapLoadPage,
    WinTkGSCanUseFont,
    WinTkGSCanUseFallback,
    WinTkGSDefaultSubFont,
    WinTkGSSubFontMeasureCharsUni,
    WinTkGSSubFontTextWidthUni,
    WinTkGSSubFontDrawCharsUni,
    WinTkGSSubFontMeasureCharsUtf,
    WinTkGSSubFontTextWidthUtf,
    WinTkGSSubFontDrawCharsUtf
};


/*
 * Drawable-related driver procs
 */

TkGS_Drawable
WinTkGS_GetDrawable(clientData)
    ClientData clientData;
{
    WinDrawableCreateData *cd = (WinDrawableCreateData *) clientData;
    TkGS_Drawable d = TkGSNewDrawable(&WinDeviceDriver);
    TkGS_InternalRep intRep;
    register TkGS_InternalRep *intRepPtr = &intRep;

    /* 
     * Initialize internal rep
     */

    /* Allocate internal rep */
    WinDrawable_InternalRep(intRepPtr) = (WinDrawable *) ckalloc(sizeof(WinDrawable));

    WinDrawable_HWND(intRepPtr) = cd->hwnd;

    /* Set fields to NULL for lazy creation */
    WinDrawable_HDC(intRepPtr)    = NULL;
    WinDrawable_HPEN(intRepPtr)   = NULL;
    WinDrawable_HBRUSH(intRepPtr) = NULL;

    /* No selected subfont by default. */
    WinDrawable_SubFontId(intRepPtr) = 0;

    intRepPtr->typePtr = WinDrawableTypePtr;

    /*
     * Add internal rep to object
     */

    TkGS_PushInternalRep((TkGS_Obj *) d, intRepPtr);

    return d;
}

int
WinTkGSUpdateDrawableState(d, valueMask)
    TkGS_Drawable d;
    unsigned long valueMask;
{
    register TkGS_GCValues *gcValues = &TkGSDrawable_GCValues(d);
    register unsigned long *gcValueMask = &TkGSDrawable_GCValueMask(d);
    register TkGS_InternalRep *intRepPtr
	= TkGS_FindInternalRep((TkGS_Obj *) d, WinDrawableTypePtr);
    register HDC hdc;

    /*
     * Update GC state if needed; this may change the GC values' internal rep
     */

    if (WinDrawable_HDC(intRepPtr) == NULL) {
	hdc = GetDC(WinDrawable_HWND(intRepPtr));
	SetTextAlign(hdc, TA_LEFT | TA_BASELINE);

	WinDrawable_HDC(intRepPtr) = hdc;
    } else {
	hdc = WinDrawable_HDC(intRepPtr); 
    }
    valueMask &= *gcValueMask;
    if (valueMask == 0) {
	return TKGS_OK;
    }
    
    /* foreground or lineWidth => pen */
    if (   (valueMask & TkGS_GCLineWidth)
	|| (valueMask & TkGS_GCForeground)) {
	/* Delete existing pen */
	if (WinDrawable_HPEN(intRepPtr) != NULL) {
	    DeleteObject(WinDrawable_HPEN(intRepPtr));
	    WinDrawable_HPEN(intRepPtr) = NULL;
	}
	/* FIXME: handle errors from conversion code */
	SelectObject(hdc, WinTkGS_GetPenFromDrawable(NULL, d));
    }

    /* foreground => brush */
    if (valueMask & TkGS_GCForeground) {
	/* Delete existing brush */
	if (WinDrawable_HBRUSH(intRepPtr) != NULL) {
	    DeleteObject(WinDrawable_HBRUSH(intRepPtr));
	    WinDrawable_HBRUSH(intRepPtr) = NULL;
	}
	/* FIXME: handle errors from conversion code */
	SelectObject(hdc, WinTkGS_GetBrushFromDrawable(NULL, d));
    }

    /* foreground => text color */
    if (valueMask & TkGS_GCForeground) {
	/* FIXME: handle errors from conversion code */
	SetTextColor(hdc, 
	    WinTkGS_GetColorrefFromColor(gcValues->foreground));
    }

    /* background => stippling */
    if (valueMask & TkGS_GCBackground) {
	/* TODO */
    }

    /* background => text back color */
    if (valueMask & TkGS_GCBackground) {
	if (gcValues->background) {
	    /* FIXME: handle errors from conversion code */
	    SetBkMode(hdc, OPAQUE);
	    SetBkColor(hdc, 
		WinTkGS_GetColorrefFromColor(gcValues->background));
	} else {
	    SetBkMode(hdc, TRANSPARENT);
	}
    }


    /* font */
    if (valueMask & TkGS_GCFont) {
	/* Reset subfont to base subfont. */
	TkGSSetDrawableSubFont(d, TKGS_BASE_SUBFONT);
    }

    *gcValueMask &= ~valueMask;
    return TKGS_OK;
}


/*
 * Line & shape primitives
 */

void
WinTkGS_DrawRectangle(d, filled, x, y, width, height)
    TkGS_Drawable	d;
    int			filled;
    int			x;
    int			y;
    unsigned int	width;
    unsigned int	height;
{
    DECLAREDRAWINGVARS(d, intRepPtr, hdc)
    HGDIOBJ oldObj;

    if (filled) {
	oldObj = SelectObject(hdc, GetStockObject(NULL_PEN));
    } else {
	oldObj = SelectObject(hdc, GetStockObject(NULL_BRUSH));
    }

    Rectangle(hdc, x, y, x+width+1, y+height+1);

    SelectObject(hdc, oldObj);
}

void
WinTkGS_DrawRectangles(d, filled, rectangles, nbRectangles) 
    TkGS_Drawable	d;
    int			filled;
    TkGS_Rectangle*	rectangles;
    int			nbRectangles;
{
    DECLAREDRAWINGVARS(d, intRepPtr, hdc)
    HGDIOBJ oldObj;
    int i;

    if (filled) {
	oldObj = SelectObject(hdc, GetStockObject(NULL_PEN));
    } else {
	oldObj = SelectObject(hdc, GetStockObject(NULL_BRUSH));
    }

    for (i=0; i<nbRectangles; i++) {
	Rectangle(hdc, rectangles[i].x, rectangles[i].y,
		  rectangles[i].x+rectangles[i].width+1, 
		  rectangles[i].y+rectangles[i].height+1);
    }

    SelectObject(hdc, oldObj);
}

void
WinTkGS_FillRectangle(d, color, x, y, width, height)
    TkGS_Drawable	d;
    TkGS_Color		color;
    int			x;
    int			y;
    unsigned int	width;
    unsigned int	height;
{
    DECLAREDRAWINGVARS(d, intRepPtr, hdc)
    RECT rect;
    COLORREF newColor, oldColor;

    rect.left = x;
    rect.top = y;
    rect.right = x + width;
    rect.bottom = y + height;
    newColor = WinTkGS_GetColorrefFromColor(color);
    oldColor = SetBkColor(hdc, (COLORREF)newColor);
    SetBkMode(hdc, OPAQUE);
    ExtTextOut(hdc, 0, 0, ETO_OPAQUE, &rect, NULL, 0, NULL);
    SetBkColor(hdc, oldColor);
}

void
WinTkGS_FillRectangles(d, color, rectangles, nbRectangles) 
    TkGS_Drawable	d;
    TkGS_Color		color;
    TkGS_Rectangle*	rectangles;
    int			nbRectangles;
{
    DECLAREDRAWINGVARS(d, intRepPtr, hdc)
    RECT rect;
    COLORREF newColor, oldColor;
    int i;

    newColor = WinTkGS_GetColorrefFromColor(color);
    oldColor = SetBkColor(hdc, (COLORREF)newColor);
    SetBkMode(hdc, OPAQUE);
    for (i=0; i<nbRectangles; i++) {
	rect.left = rectangles[i].x;
	rect.top = rectangles[i].y;
	rect.right = rectangles[i].x+rectangles[i].width;
	rect.bottom = rectangles[i].y+rectangles[i].height;
	ExtTextOut(hdc, 0, 0, ETO_OPAQUE, &rect, NULL, 0, NULL);
    }
    SetBkColor(hdc, oldColor);
}

void
WinTkGS_DrawEllipse(d, filled, x, y, width, height)
    TkGS_Drawable	d;
    int			filled;
    int			x;
    int			y;
    unsigned int	width;
    unsigned int	height;
{
    DECLAREDRAWINGVARS(d, intRepPtr, hdc)
    HGDIOBJ oldObj;

    if (filled) {
	oldObj = SelectObject(hdc, GetStockObject(NULL_PEN));
    } else {
	oldObj = SelectObject(hdc, GetStockObject(NULL_BRUSH));
    }

    Ellipse(hdc, x, y, x+width+1, y+height+1);

    SelectObject(hdc, oldObj);
}

void
WinTkGS_DrawEllipses(d, filled, ellipses, nbEllipses) 
    TkGS_Drawable	d;
    int			filled;
    TkGS_Rectangle*	ellipses;
    int			nbEllipses;
{
    DECLAREDRAWINGVARS(d, intRepPtr, hdc)
    HGDIOBJ oldObj;
    int i;

    if (filled) {
	oldObj = SelectObject(hdc, GetStockObject(NULL_PEN));
    } else {
	oldObj = SelectObject(hdc, GetStockObject(NULL_BRUSH));
    }

    for (i=0; i<nbEllipses; i++) {
	Ellipse(hdc, ellipses[i].x, ellipses[i].y,
		ellipses[i].x+ellipses[i].width+1, 
		ellipses[i].y+ellipses[i].height+1);
    }

    SelectObject(hdc, oldObj);
}


/*
 * Initialization code
 */

WinTkGSGetScreenFontProc *WinTkGSGetScreenFont;
WinTkGSGetFaceNameProc *WinTkGSGetFaceName;


static void
WinTkGSInit()
{
    OSVERSIONINFO osVersion;

    /*
     * TkGS_Obj base types.
     */

    WinDrawableTypePtr->baseTypePtr = TkGS_GetDrawableBaseType();
    WinColorTypePtr->baseTypePtr    = TkGS_GetColorBaseType();
    WinFontTypePtr->baseTypePtr     = TkGS_GetFontBaseType();

    /*
     * System-specific initialization.
     */

    GetVersionEx(&osVersion);
    switch (osVersion.dwPlatformId) {
	case VER_PLATFORM_WIN32_NT:
	    WinDeviceDriver.enumerateFontFamilies
		= WinTkGS_EnumerateFontFamiliesUni;
	    WinDeviceDriver.fontFamilyExists
		= WinTkGS_FontFamilyExistsUni;

	    WinTkGSGetScreenFont = WinTkGSGetScreenFontUni;
	    WinTkGSGetFaceName = WinTkGSGetFaceNameUni;
	    break;

	case VER_PLATFORM_WIN32_WINDOWS:
	case VER_PLATFORM_WIN32s:
	default:
	    /* FIXME: See if Windows 9x support Unicode properly. */
	    WinDeviceDriver.enumerateFontFamilies
		= WinTkGS_EnumerateFontFamiliesSys;
	    WinDeviceDriver.fontFamilyExists
		= WinTkGS_FontFamilyExistsSys;

	    WinTkGSGetScreenFont = WinTkGSGetScreenFontSys;
	    WinTkGSGetFaceName = WinTkGSGetFaceNameSys;
    }

    /*
     * Font subpackage initialization.
     */

    WinTkGSInitFontPackage();

    /*
     * Device driver registration.
     */

    TkGS_RegisterDeviceDriver(&WinDeviceDriver);

}

void
WinTkGS_StaticPackage(interp)
    Tcl_Interp *interp;
{  
    Tcl_StaticPackage(interp, "Wintkgs", Wintkgs_Init, Wintkgs_SafeInit);
}


/*
 *----------------------------------------------------------------------
 *
 * Wintkgs_Init --
 *
 *	This function is used to initialize the package. Here we check
 *	dependencies with other packages (eg Tcl), create new commands,
 *	and register our packages
 *
 * Results:
 *	A standard Tcl result.
 *
 * Side effects:
 *	New commands created, and package registered (see documentation).
 *
 *----------------------------------------------------------------------
 */

int Wintkgs_Init(interp)
    Tcl_Interp *interp;
{  
#ifdef USE_TCL_STUBS
    if (Tcl_InitStubs(interp, "8.3", 0) == NULL) {
	return TCL_ERROR;
    }
#endif

#ifdef USE_TK_STUBS
    if (Tk_InitStubs(interp, "8.3", 0) == NULL) {
	return TCL_ERROR;
    }
#endif

    /* Dependencies */
    if (Tcl_PkgRequire(interp, "TkGS", "1.0", 0) == NULL)
	return TCL_ERROR;

    /* Package provided */
    if (Tcl_PkgProvide(interp, "WinTkGS", "1.0") == TCL_ERROR)
	return TCL_ERROR;

    WinTkGSInit();

    return TCL_OK;
}


/*
 *----------------------------------------------------------------------
 *
 * Wintkgs_SafeInit --
 *
 *	This function is used to initialize the package in the special case
 *	of safe interpreters (like the Tcl Plugin). Here we check
 *	dependencies with other packages (eg Tcl), create new commands,
 *	and register our packages
 *
 * Results:
 *	A standard Tcl result.
 *
 * Side effects:
 *	New commands created, and package registered (see documentation).
 *
 *----------------------------------------------------------------------
 */

int Wintkgs_SafeInit(interp)
    Tcl_Interp *interp;
{  
    /* For now, do the same as with unsafe interpreters */
    return Wintkgs_Init(interp);
}

