#include <tkgs.h>
#include <tkgsInt.h>
#include <string.h>

#include "tkgsXlib.h"
#include "tkgsXlibInt.h"

/*
 * Prototypes for procedures defined later in this file:
 */

/* Driver */

static TkGS_GetDrawableProc		XlibTkGS_GetDrawable;

static TkGSUpdateDrawableStateProc	XlibTkGSUpdateDrawableState;

static TkGS_DrawRectangleProc		XlibTkGS_DrawRectangle;
static TkGS_DrawRectanglesProc		XlibTkGS_DrawRectangles;
static TkGS_FillRectangleProc		XlibTkGS_FillRectangle;
static TkGS_FillRectanglesProc		XlibTkGS_FillRectangles;
static TkGS_DrawEllipseProc		XlibTkGS_DrawEllipse;
static TkGS_DrawEllipsesProc		XlibTkGS_DrawEllipses;



/*
 * Driver
 */

TkGS_DeviceDriver XlibDeviceDriver = {
    "Xlib",

    XlibTkGS_GetDrawable,

    XlibTkGSUpdateDrawableState,

    /* Line & shape primitives */
    XlibTkGS_DrawRectangle,
    XlibTkGS_DrawRectangles,
    XlibTkGS_FillRectangle,
    XlibTkGS_FillRectangles,
    XlibTkGS_DrawEllipse,
    XlibTkGS_DrawEllipses,

    /* Fonts and text primitives: */
    XlibTkGS_GetFontMetrics,
    XlibTkGS_GetActualFontAttributes,
    XlibTkGS_EnumerateFontFamilies,
    XlibTkGS_FontFamilyExists,

    /*  - Unicode */
    XlibTkGS_MeasureCharsUni,
    NULL,
    XlibTkGS_DrawCharsUni,
    NULL,

    /*  - UTF-8 */
    XlibTkGS_MeasureCharsUtf,
    NULL,
    XlibTkGS_DrawCharsUtf,
    NULL,

    /*  - System-specific */
    NULL,
    XlibTkGS_TextWidthSys,
    XlibTkGS_DrawCharsSys,
    NULL,

    /*  - Multi-font Unicode system */
    1,					/* Non-native Unicode */
    1,					/* There may be distinct fonts with
					 * the same face name. */
    XlibTkGSGetSubFont,
    XlibTkGSSetDrawableSubFont,
    XlibTkGSFontMapLoadPage,
    XlibTkGSCanUseFont,
    XlibTkGSCanUseFallback,
    XlibTkGSDefaultSubFont,
    XlibTkGSSubFontMeasureCharsUni,
    XlibTkGSSubFontTextWidthUni,
    XlibTkGSSubFontDrawCharsUni,
    XlibTkGSSubFontMeasureCharsUtf,
    XlibTkGSSubFontTextWidthUtf,
    XlibTkGSSubFontDrawCharsUtf
};


/*
 * Drawable-related driver procs
 */

TkGS_Drawable
XlibTkGS_GetDrawable(clientData)
    ClientData clientData;
{
    XlibDrawableCreateData *cd = (XlibDrawableCreateData *) clientData;
    TkGS_Drawable d = TkGSNewDrawable(&XlibDeviceDriver);
    TkGS_InternalRep intRep;
    register TkGS_InternalRep *intRepPtr = &intRep;

    /* Allocate internal rep */
    XlibDrawable_InternalRep(intRepPtr) = (XlibDrawable*) ckalloc(sizeof(XlibDrawable));

    /* 
     * Initialize internal rep
     */

    XlibDrawable_Display(intRepPtr)  = cd->display;
    XlibDrawable_Drawable(intRepPtr) = cd->d;
    XlibDrawable_Colormap(intRepPtr) = cd->colormap;

    /* Set GC to None for lazy creation */
    XlibDrawable_GC(intRepPtr)       = None; 

    intRepPtr->typePtr = XlibDrawableTypePtr;

    /*
     * Add internal rep to object
     */

    TkGS_PushInternalRep((TkGS_Obj *) d, intRepPtr);

    return d;
}

int
XlibTkGSUpdateDrawableState(d, valueMask)
    TkGS_Drawable d;
    unsigned long valueMask;
{
    register TkGS_GCValues *gcValues = &TkGSDrawable_GCValues(d);
    register unsigned long *gcValueMask = &TkGSDrawable_GCValueMask(d);
    register TkGS_InternalRep 
	*intRepPtr = TkGS_FindInternalRep((TkGS_Obj *) d, XlibDrawableTypePtr);
    XGCValues xgcValues;
    unsigned long mask;

    /*
     * Update GC state if needed; this may change the GC values' internal rep
     */

    valueMask &= *gcValueMask;
    if (valueMask == 0) {
	return TKGS_OK;
    }

    mask = 0;

    /* foreground */
    /* FIXME: handle errors from conversion code */
    if (valueMask & TkGS_GCForeground) {
	xgcValues.foreground = 
	    XlibTkGS_GetXColorFromColor(NULL, gcValues->foreground, d)->pixel;
	mask |= GCForeground;
    }
    
    /* background */
    /* FIXME: handle errors from conversion code */
    if (valueMask & TkGS_GCBackground) {
	if (gcValues->background) {
	    xgcValues.background = 
		XlibTkGS_GetXColorFromColor(NULL, gcValues->background, d)->pixel;
	} else {
	    xgcValues.background = None;
	}
	mask |= GCBackground;
    }

    /* lineWidth */
    if (valueMask & TkGS_GCLineWidth) {
	xgcValues.line_width = gcValues->lineWidth;
	mask |= GCLineWidth;
    }

    /* Update or create GC */
    if (XlibDrawable_GC(intRepPtr) == None) {
	XlibDrawable_GC(intRepPtr) = XCreateGC(XlibDrawable_Display(intRepPtr), 
					       XlibDrawable_Drawable(intRepPtr), 
					       mask, &xgcValues);
    } else {
	XChangeGC(XlibDrawable_Display(intRepPtr), XlibDrawable_GC(intRepPtr), 
		  mask, &xgcValues);
    }

    /* font */
    if (valueMask & TkGS_GCFont) {
	/* Reset subfont to base subfont. */
	TkGSSetDrawableSubFont(d, TKGS_BASE_SUBFONT);
    }

    *gcValueMask &= ~valueMask;
    return TKGS_OK;
}


/*
 * Line & shape primitives
 */

void
XlibTkGS_DrawRectangle(d, filled, x, y, width, height)
    TkGS_Drawable	d;
    int			filled;
    int			x;
    int			y;
    unsigned int	width;
    unsigned int	height;
{
    DECLAREDRAWINGVARS(d, intRepPtr, display, xd, xgc)

    if (filled) {
	XFillRectangle(display, xd, xgc, 
		x, y, width, height);
    } else {
	XDrawRectangle(display, xd, xgc, 
		x, y, width, height);
    }
}

void
XlibTkGS_DrawRectangles(d, filled, rectangles, nbRectangles) 
    TkGS_Drawable	d;
    int			filled;
    TkGS_Rectangle*	rectangles;
    int			nbRectangles;
{
    DECLAREDRAWINGVARS(d, intRepPtr, display, xd, xgc)
    int i;

    /* TODO: see if we can call XFillRectangles instead and if 
     * it gives better performances */

    if (filled) {
	for (i=0; i<nbRectangles; i++) {
	    XFillRectangle(display, xd, xgc, 
			   rectangles[i].x, rectangles[i].y, 
			   rectangles[i].width, rectangles[i].height);
	}
    } else {
	for (i=0; i<nbRectangles; i++) {
	    XDrawRectangle(display, xd, xgc, 
			   rectangles[i].x, rectangles[i].y, 
			   rectangles[i].width, rectangles[i].height);
	}
    }
}

void
XlibTkGS_FillRectangle(d, color, x, y, width, height)
    TkGS_Drawable	d;
    TkGS_Color		color;
    int			x;
    int			y;
    unsigned int	width;
    unsigned int	height;
{
    DECLAREDRAWINGVARS(d, intRepPtr, display, xd, xgc)
    GC cgc = XlibTkGS_GetColorGCFromColor(NULL, color, d);

    XFillRectangle(display, xd, cgc, 
		x, y, width, height);
}

void
XlibTkGS_FillRectangles(d, color, rectangles, nbRectangles) 
    TkGS_Drawable	d;
    TkGS_Color		color;
    TkGS_Rectangle*	rectangles;
    int			nbRectangles;
{
    DECLAREDRAWINGVARS(d, intRepPtr, display, xd, xgc)
    GC cgc = XlibTkGS_GetColorGCFromColor(NULL, color, d);
    int i;

    /* TODO: see if we can call XFillRectangles instead and if 
     * it gives better performances */

    for (i=0; i<nbRectangles; i++) {
	XFillRectangle(display, xd, cgc, 
		       rectangles[i].x, rectangles[i].y, 
		       rectangles[i].width, rectangles[i].height);
    }
}

void
XlibTkGS_DrawEllipse(d, filled, x, y, width, height)
    TkGS_Drawable	d;
    int			filled;
    int			x;
    int			y;
    unsigned int	width;
    unsigned int	height;
{
    DECLAREDRAWINGVARS(d, intRepPtr, display, xd, xgc)

    if (filled) {
	XFillArc(display, xd, xgc, 
		x, y, width, height, 0, 360*64);
    } else {
	XDrawArc(display, xd, xgc, 
		x, y, width, height, 0, 360*64);
    }
}

void
XlibTkGS_DrawEllipses(d, filled, ellipses, nbEllipses) 
    TkGS_Drawable	d;
    int			filled;
    TkGS_Rectangle*	ellipses;
    int			nbEllipses;
{
    DECLAREDRAWINGVARS(d, intRepPtr, display, xd, xgc)
    int i;

    /* TODO: see if we can call XFillArcs instead and if 
     * it gives better performances */

    if (filled) {
	for (i=0; i<nbEllipses; i++) {
	    XFillArc(display, xd, xgc, 
		     ellipses[i].x, ellipses[i].y, 
		     ellipses[i].width, ellipses[i].height,
		     0, 360*64);
	}
    } else {
	for (i=0; i<nbEllipses; i++) {
	    XDrawArc(display, xd, xgc, 
		     ellipses[i].x, ellipses[i].y, 
		     ellipses[i].width, ellipses[i].height,
		     0, 360*64);
	}
    }
}


/*
 * Initialization code
 */

static void
XlibTkGSInit()
{
    /*
     * TkGS_Obj base types.
     */

    XlibDrawableTypePtr->baseTypePtr = TkGS_GetDrawableBaseType();
    XlibColorTypePtr->baseTypePtr    = TkGS_GetColorBaseType();
    XlibFontTypePtr->baseTypePtr     = TkGS_GetFontBaseType();

    /*
     * Font subpackage initialization.
     */

    XlibTkGSInitFontPackage();

    /*
     * Device driver registration.
     */

    TkGS_RegisterDeviceDriver(&XlibDeviceDriver);
}

void
XlibTkGS_StaticPackage(interp)
    Tcl_Interp *interp;
{  
    Tcl_StaticPackage(interp, "Xlibtkgs", Xlibtkgs_Init, Xlibtkgs_SafeInit);
}


/*
 *----------------------------------------------------------------------
 *
 * Xlibtkgs_Init --
 *
 *	This function is used to initialize the package. Here we check
 *	dependencies with other packages (eg Tcl), create new commands,
 *	and register our packages
 *
 * Results:
 *	A standard Tcl result.
 *
 * Side effects:
 *	New commands created, and package registered (see documentation).
 *
 *----------------------------------------------------------------------
 */

int Xlibtkgs_Init(interp)
    Tcl_Interp *interp;
{  
#ifdef USE_TCL_STUBS
    if (Tcl_InitStubs(interp, "8.3", 0) == NULL) {
	return TCL_ERROR;
    }
#endif

#ifdef USE_TK_STUBS
    if (Tk_InitStubs(interp, "8.3", 0) == NULL) {
	return TCL_ERROR;
    }
#endif

    /* Dependencies */
    if (Tcl_PkgRequire(interp, "TkGS", "1.0", 0) == NULL)
	return TCL_ERROR;

    /* Package provided */
    if (Tcl_PkgProvide(interp, "XlibTkGS", "1.0") == TCL_ERROR)
	return TCL_ERROR;

    XlibTkGSInit();

    return TCL_OK;
}


/*
 *----------------------------------------------------------------------
 *
 * Xlibtkgs_SafeInit --
 *
 *	This function is used to initialize the package in the special case
 *	of safe interpreters (like the Tcl Plugin). Here we check
 *	dependencies with other packages (eg Tcl), create new commands,
 *	and register our packages
 *
 * Results:
 *	A standard Tcl result.
 *
 * Side effects:
 *	New commands created, and package registered (see documentation).
 *
 *----------------------------------------------------------------------
 */

int Xlibtkgs_SafeInit(interp)
    Tcl_Interp *interp;
{  
    /* For now, do the same as with unsafe interpreters */
    return Xlibtkgs_Init(interp);
}

