#ifndef _TKGSXLIB
#define _TKGSXLIB

#include <tkgs.h>

/*
 *--------------------------------------------------------------
 *
 * Tcl package initialization
 *
 *--------------------------------------------------------------
 */


/*
 * if the BUILD_XlibTkGS macro is defined, the assumption is that we are
 * building the dynamic library.
 */

#ifdef BUILD_XlibTkGS
#   undef TCL_STORAGE_CLASS
#   define TCL_STORAGE_CLASS DLLEXPORT
#endif

#define EXPORT(a,b) a b

#ifdef WIN32
#   define WIN32_LEAN_AND_MEAN
#   include <windows.h>
#   undef WIN32_LEAN_AND_MEAN

#   ifndef STATIC_BUILD
#	if defined(__BORLANDC__)
#           undef EXPORT
#           define EXPORT(a,b) a _export b
#	endif
#   endif
#endif	/* WIN32 */

/*
 * The DLL's main entry point
 */

EXTERN EXPORT(int,Xlibtkgs_Init) _ANSI_ARGS_((Tcl_Interp *interp));
EXTERN EXPORT(int,Xlibtkgs_SafeInit) _ANSI_ARGS_((Tcl_Interp *interp));

void XlibTkGS_StaticPackage _ANSI_ARGS_((Tcl_Interp *interp));


/*
 * Xlib-dependent structures
 */

#ifdef MAC_TCL
#   include <Xlib.h>
#   include <X.h>
#else
#   include <X11/Xlib.h>
#endif


/* Drawable initialization structure */

typedef struct XlibDrawableCreateData {
    Display* display;
    Colormap colormap;
    Drawable d;
} XlibDrawableCreateData;

/* Various functions */

EXTERN XColor *		XlibTkGS_GetXColorFromColor _ANSI_ARGS_((
			    Tcl_Interp *interp, TkGS_Color color,
			    TkGS_Drawable d));
EXTERN GC		XlibTkGS_GetColorGCFromColor _ANSI_ARGS_((
			    Tcl_Interp *interp, TkGS_Color color,
			    TkGS_Drawable d));

/*
 * end of tkgsXlib.h
 * reset TCL_STORAGE_CLASS to DLLIMPORT.
 */

#undef TCL_STORAGE_CLASS
#define TCL_STORAGE_CLASS DLLIMPORT

#endif /* _TKGSXLIB */
