#include "tkgsXlib.h"
#include "tkgsXlibInt.h"

/*
 * Prototypes for procedures defined later in this file:
 */

static TkGS_FreeInternalRepProc		FreeXlibColorIntRep;
static TkGS_SetFromAnyProc		SetXlibColorFromAny;


/*
 * Xlib Color Obj type
 */

/* Object type */
TkGS_ObjType XlibColorType = {
    "XlibColor",
    NULL,				/* Base type, initialized at runtime */

    FreeXlibColorIntRep,		/* freeIntRepProc */
    SetXlibColorFromAny			/* setFromAnyProc */
};
TkGS_ObjType *XlibColorTypePtr = &XlibColorType;


/* Object type procs */

static void
FreeXlibColorIntRep(intRepPtr)
    TkGS_InternalRep *intRepPtr;
{
    /* Free X structures */
    if (XlibColor_XColor(intRepPtr) != None) {
	XFreeColors(XlibColor_Display(intRepPtr), XlibColor_Colormap(intRepPtr),
	    &XlibColor_XColor(intRepPtr)->pixel, 1, 0);
    }
    if (XlibColor_ColorGC(intRepPtr) != None) {
	XFreeGC(XlibColor_Display(intRepPtr), XlibColor_ColorGC(intRepPtr));
    }

    /* Free the allocated memory */
    ckfree((char *) XlibColor_InternalRep(intRepPtr));
}

static int
SetXlibColorFromAny(interp, objPtr, intRepPtr)
    Tcl_Interp *interp;
    TkGS_Obj *objPtr;
    TkGS_InternalRep *intRepPtr;
{
    /* 
     * Free old internal rep
     */

    if (   intRepPtr->typePtr != NULL
	&& intRepPtr->typePtr->freeIntRepProc != NULL) {
	intRepPtr->typePtr->freeIntRepProc(intRepPtr);
    }

    /* 
     * Initialize internal rep
     */

    XlibColor_InternalRep(intRepPtr) = (XlibColor*) ckalloc(sizeof(XlibColor));

    XlibColor_Display(intRepPtr)  = None;
    XlibColor_Colormap(intRepPtr) = None;
    XlibColor_XColor(intRepPtr)   = None;
    XlibColor_ColorGC(intRepPtr)  = None;

    /* Change type */
    intRepPtr->typePtr = &XlibColorType;

    return TKGS_OK;
}



XColor *
XlibTkGS_GetXColorFromColor(interp, color, d)
    Tcl_Interp *interp;
    TkGS_Color color;
    TkGS_Drawable d;
{
    register TkGS_InternalRep 
	*dIntRepPtr     = TkGS_FindInternalRep((TkGS_Obj *) d, XlibDrawableTypePtr),
	*colorIntRepPtr = TkGS_FindInternalRep((TkGS_Obj *) color, &XlibColorType);

    /*
     * Get a Xlib XColor from TkGS Color's internal rep
     */

    if (   colorIntRepPtr == NULL
	|| XlibColor_Display(colorIntRepPtr)  != XlibDrawable_Display(dIntRepPtr)
	|| XlibColor_Colormap(colorIntRepPtr) != XlibDrawable_Colormap(dIntRepPtr)) {
	colorIntRepPtr = TkGS_AddNewInternalRep(interp, (TkGS_Obj *) color, 
						&XlibColorType);
	if (!colorIntRepPtr) {
	    return None;
	}
	XlibColor_Display(colorIntRepPtr)  = XlibDrawable_Display(dIntRepPtr);
	XlibColor_Colormap(colorIntRepPtr) = XlibDrawable_Colormap(dIntRepPtr);
    }

    if (XlibColor_XColor(colorIntRepPtr) == None) {
	/* Create XColor */
	XColor *xc;

	xc = XlibColor_XColor(colorIntRepPtr) = (XColor *) ckalloc(sizeof(XColor));
	TkGS_GetRGBColorValues(color, &xc->red, &xc->green, &xc->blue);
	XAllocColor(XlibColor_Display(colorIntRepPtr), 
		    XlibColor_Colormap(colorIntRepPtr),
		    XlibColor_XColor(colorIntRepPtr));
    }

    return XlibColor_XColor(colorIntRepPtr);
}


GC
XlibTkGS_GetColorGCFromColor(interp, color, d)
    Tcl_Interp *interp;
    TkGS_Color color;
    TkGS_Drawable d;
{
    register TkGS_InternalRep 
	*dIntRepPtr     = TkGS_FindInternalRep((TkGS_Obj *) d, XlibDrawableTypePtr),
	*colorIntRepPtr;
    XColor *xc;

    /*
     * Get a Xlib GC from TkGS Color's internal rep, ie a GC where the
     * foreground color is set to the current color.
     */

    /* First get XColor (update internal rep if necessary) */
    xc = XlibTkGS_GetXColorFromColor(interp, color, d);
    if (xc == None) {
	return None;
    }

    /* The following pointer can be used safely */
    colorIntRepPtr = TkGS_FindInternalRep((TkGS_Obj *) color, &XlibColorType);

    if (XlibColor_ColorGC(colorIntRepPtr) == None) {
	/* Create GC with the above foreground color */
	XGCValues xgcValues;

	xgcValues.foreground = xc->pixel;
	XlibColor_ColorGC(colorIntRepPtr) = XCreateGC(XlibDrawable_Display(dIntRepPtr), 
						XlibDrawable_Drawable(dIntRepPtr), 
						GCForeground, &xgcValues);
    }

    return XlibColor_ColorGC(colorIntRepPtr);
}
