#include "tkgsXlib.h"
#include "tkgsXlibInt.h"

/*
 * Prototypes for procedures defined later in this file:
 */

static TkGS_FreeInternalRepProc		FreeXlibDrawableIntRep;


/*
 * Xlib Drawable Obj type
 */

/* Object type */
TkGS_ObjType XlibDrawableType = {
    "XlibDrawable",
    NULL,				/* Base type, initialized at runtime */

    FreeXlibDrawableIntRep,		/* freeIntRepProc */
    NULL				/* setFromAnyProc */
					/* NULL means immutable */
};
TkGS_ObjType *XlibDrawableTypePtr = &XlibDrawableType;

/* Object type procs */

static void
FreeXlibDrawableIntRep(intRepPtr)
    TkGS_InternalRep *intRepPtr;
{
    /* Free X structures */
    if (XlibDrawable_GC(intRepPtr) != None) {
	XFreeGC(XlibDrawable_Display(intRepPtr), XlibDrawable_GC(intRepPtr));
    }

    /* Free the allocated memory */
    ckfree((char *) XlibDrawable_InternalRep(intRepPtr));
}
