# UserMaint V1.0 by Charles A. Eads
#
# Copyright (c) 1993 The Regents of the University of California.
# All rights reserved.
# 
# Permission to use, copy, modify, and distribute this software and its
# documentation for any purpose, without fee, and without written agreement is
# hereby granted, provided that the above copyright notice and the following
# two paragraphs appear in all copies of this software.
# 
# IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY FOR
# DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
# OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE UNIVERSITY OF
# CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
# 
# THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
# INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
# AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
# ON AN "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO
# PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.

proc add_control_create {w win} \
{
	global BACKGROUND_COLOR_ADD_EDIT
	frame $w.control -border 5 -background $BACKGROUND_COLOR_ADD_EDIT
	button $w.control.add -text "Add User" -command "add_add $w {$win}"
	button $w.control.cancel -width 8 -text "Cancel" -command "add_finish $w {$win}"
	pack append $w.control $w.control.add {left} $w.control.cancel {right}
}

proc add_create {w} \
{
	set index [lindex [$w.userlist.list curselection] 0]
	upvar #0 window_number wnumber
	if {$index != {}} \
	{
		userlist_tag $w $index .add-$wnumber
	}
	toplevel .add-$wnumber
	useredit_create .add-$wnumber $w
	add_control_create .add-$wnumber $w
	pack append .add-$wnumber .add-$wnumber.useredit {top fill} .add-$wnumber.control {bottom expand fill}

	useredit_init .add-$wnumber {} {} {} {} {} {} {}

	wm title .add-$wnumber "ADD USER"

	incr wnumber
}

proc add_add {w win} \
{
	upvar #0 tmp_passwd_text([expr "{$win} == {} ? {.} : {$win}"]) tmp_passwd_text
	upvar #0 tmp_gid($w) tmp_gid
	global group_text

	set user_entry [useredit_get_user_entry $w]
	if {$user_entry == -1} return

	set add_index end
	set i [userlist_tag_find $win $w]
	if { $i != -1 } \
	{
		set add_index [expr "$i + 1"]
		userlist_tag_remove $win $i [userlist_get_user_entry $win $i] $w
	}
	useredit_apply $w $win
	if {$add_index == {end}} {set add_index [$win.userlist.list size]}
	$win.userlist.list insert $add_index $user_entry
	userlist_tag $win $add_index .added
	set passwd_entry [useredit_get_passwd_entry $w]
	set tmp_passwd_text [linsert $tmp_passwd_text $add_index [file_to_list $passwd_entry]]

	follow $win.userlist.list $add_index 30

	destroy $w
}

proc add_finish {w win} \
{
	set i [userlist_tag_find $win $w]
	if { $i != -1 } \
	{
		userlist_tag_remove $win $i [userlist_get_user_entry $win $i] $w
	}
	destroy $w
}
