# Bindings for textual documents

proc beginning_of_paragraph {t index} {
	set beginning [string last "\n\n" [$t get 1.0 $index]]
	if {($beginning == -1)} {return "1.0"
	} else {return "1.0 +$beginning chars +2 chars"}
}

proc end_of_paragraph {t index} {
	set end [string first "\n\n" [$t get $index end]]
	if {($end == -1)} {return end
	} else {return "insert +$end chars"}
}

proc select_paragraph {t index} {
	catch {$t tag remove sel sel.first sel.last}
	$t tag add sel [beginning_of_paragraph $t $index] \
			[end_of_paragraph $t $index]
}


# Splits line if it is longer than length. Returns number of extra lines
# produced (0 is if line was not broken). Index is on line to break, length
# is desired length, string is contents of line.
proc split_line {t {index insert} {length ""} {string ""}} {
	if {($string == "")} {
		set string [$t get "$index linestart" "$index lineend"]
	}
	if {($length == "")} {scan [wm geometry .] { %d } length}
	if {([string length $string] < $length)} {return 0}

	set offset [string last " " [string range $string 0 $length]]
	if {($offset < 0)} {return 0}
	set break [$t index "$index linestart +$offset chars"]
	$t delete $break
	$t insert $break \n
	set breaks [split_line $t "$break +1 chars" $length]
	global modified ; set modified 1
	return [incr breaks]
}

# Adjusts region in [index1 index2], so that no lines wrap
proc adjust_region {t index1 index2} {
	set chars [$t get $index1 $index2]
	set m1 [gensym] ; set m2 [gensym]
	$t mark set $m1 $index1 ; $t mark set $m2 $index2
	register_undoable_cmd $t [list undo_filter $t $m1 $m2 $chars] "Adjust $chars" "$m1 $m2"

	set trace $index1
	while {([set offset [string first \n [$t get $trace $index2]]] >= 0)} {
		set trace [$t index "$trace +$offset chars"]
		global modified ; set modified 1
		$t delete $trace ;	$t insert $trace " "
	}
	split_line $t $index1
}

proc adjust_selection {t} {
	if {([catch {$t get sel.first}])} {
		select_paragraph $t insert
		adjust_region $t sel.first sel.last
		$t tag remove sel 1.0 end
	} else {adjust_region $t sel.first sel.last
}}


# Textual bindings.
proc textbind {} {
	bind Text <Meta-a> {move_insert %W [beginning_of_paragraph %W insert]}
	bind Text <Meta-e> {move_insert %W [end_of_paragraph %W insert]}
	bind Text <Control-j> "select_paragraph %W insert"
	bind Text <Meta-j> "adjust_selection %W"

	bind Text <Return> {+split_line %W {insert -1 chars}}
	bind Text <Shift-Return> "[bind Text <Return>] ; [bind Text <Return>]"
}

textbind

$text configure -wrap word

flash_label $frame -text "Loaded text bindings"
