/* Copyright (c) 1993 by Sanjay Ghemawat */
#ifndef _COLLECT_H
#define _COLLECT_H

/*
 * Collect item occurrences.
 */

#include "Array.h"
#include "Date.h"

class Item_Tcl;

/*
 * Item listing sorted by occurrence date.
 */

struct Occurrence {
    Item_Tcl* item;
    Date      date;

    // The following are needed because older versions of g++ (before 2.3.3)
    // do not seem to generate default constructors correctly

    Occurrence() { }
    Occurrence(Occurrence const& o) {
	item = o.item;
	date = o.date;
    }
    Occurrence& operator = (Occurrence const& o) {
	item = o.item;
	date = o.date;
	return *this;
    }
};

declareArray(Occurrences,Occurrence)

/*
 * Fill list with occurrences in specified range.
 *
 * If earlywarning is true, also consider items whose early warning
 * period falls in the specified range.
 */
extern void collect_occurrences(Occurrences& list,
				Date start,
				Date finish,
				int  earlywarning);

/*
 * Sort occurrences.
 */
extern void sort_occurrences(Occurrences&);

#endif /* _COLLECT_H */
