# Copyright (c) 1993 by Sanjay Ghemawat
###############################################################################
# Calendar IO

# effects - Create thread that periodically performs required IO.
proc io_thread {} {
    do_io [expr [pref pollSeconds]*1000]
}

proc do_io {interval} {
    io_checks
    after $interval do_io $interval
}

# effects - Perform IO checks.
proc io_checks {} {
    trigger fire save

    # Cannot use [calendar_filenames] because main calendar may change
    # in the middle of the iteration.

    io_check [cal main]
    cal forincludes x {
	io_check $x
    }
}

# effects - Perform IO checks on specified calendar.
#	    Returns true iff new items were read.
proc io_check {calendar} {
    set stale [cal stale $calendar]
    set dirty [cal dirty $calendar]

    if {!$stale && !$dirty} {return}

    if {$stale && !$dirty} {
	trigger fire exclude $calendar
	if [catch {cal reread $calendar} result] {
	    error_notify "" "$calendar\n\n$result"
	}
	trigger fire include $calendar
	return
    }

    if {!$stale && $dirty} {
	if [catch {cal save $calendar} result] {
	    error_notify "" "$calendar\n\n$result"
	}
	return
    }

    if {$stale && $dirty} {
	set result [yes_or_no	""\
				"Conflicting changes to $calendar"\
				"Read from disk"\
				"Overwrite"]
	if {$result} {
	    # Discard local changes
	    trigger fire exclude $calendar
	    if [catch {cal reread $calendar} result] {
		error_notify "" "$calendar\n\n$result"
	    }
	    trigger fire include $calendar
	}

	# Overwrite other changes
	if [catch {cal save $calendar} result] {
	    error_notify "" "$calendar\n\n$result"
	}
	return 0
    }
}
