dnl Copyright (c) 1993 by Sanjay Ghemawat
dnl
ccc_cflags=''
ccc_compile='$CCC $ccc_cflags $DEFS conftest.cc -o conftest >/dev/null 2>&1'
dnl
define(ACAUX_PROG_CCC,
[AC_PROVIDE([$0])AC_PROGRAMS_CHECK(CCC,cxx g++ cc++ CC)
if test -z "$CCC"; then
  cat << EOM
This package requires a C++ compiler, but I could not find one. Set
the environment variable CCC to the name of your C++ compiler and
rerun configure.
EOM
  exit 1
fi
if test "$CCC" = "g++"; then
  ccc_cflags="-Werror"
fi
])dnl
define(ACAUX_CCC_COMPILE_CHECK,
[AC_PROVIDE([$0])dnl
ifelse([$1], , , [echo checking for $1]
)dnl
cat > conftest.cc <<EOF
[$2]
int main() { return 0; }
void t() { [$3] }
EOF
dnl Don't try to run the program, which would prevent cross-configuring.
if eval $ccc_compile; then
  ifelse([$4], , :, [$4])
ifelse([$5], , , [else
  $5
])dnl
fi
rm -f conftest*]
)dnl
define(ACAUX_PROGRAM_FULLPATH,
[AC_PROVIDE([$0])AC_PROGRAMS_CHECK($1,$2)
if test -n "[$]$1"; then
  IFS="${IFS= 	}"; saveifs="$IFS"; IFS="${IFS}:"
  for dir in $PATH; do
    test -z "$dir" && dir=.
    if test "$dir" != "." && test -f "$dir/[$]$1"; then
      $1="$dir/[$]$1"
      break
    fi
  done
  IFS="$saveifs"
fi])dnl
define(ACAUX_LIB_FINDPATH,
[AC_PROVIDE([$0])
if test -z "[$]$1[lib]"; then
  echo checking for $1 library
  $1[lib]=nope
  for d in /usr/local/lib /usr/lib; do
    if test -f "$d/lib$1.a"; then
      $1[lib]=$d
      break
    fi
    if test -f "$d/lib$1.so"; then
      $1[lib]=$d
      break
    fi
    if test -f "$d/lib$1.so.*"; then
      $1[lib]=$d
      break
    fi
  done
  if test "[$]$1[lib]" = nope; then
    cat << EOM
I could not find the $1 library.  Please set the environment variable
$1[lib] to the directory that contains the library and rerun configure.
EOM
    exit 1
  fi
fi
# Plug -L in front of it
$1[lib]="-L$[$1][lib]"
test -n "$verbose" && echo "	setting $1[lib] to [$]$1[lib]"
AC_SUBST($1[lib])])dnl
define(ACAUX_INC_FINDPATH,
[AC_PROVIDE([$0])
if test -z "$[$1]"; then
  echo checking for include file $2
  $1=nope
  for d in /usr/local/include /usr/include; do
    if test -f "$d/$2"; then
      $1=$d
      break
    fi
  done
  if test "[$]$1" = nope; then
    cat << EOM
I could not find include file $2.  Please set the environment variable
$1 to the directory that contains the include file and rerun configure.
EOM
    exit 1
  fi
  if test "[$]$1" = "/usr/include"; then
    # Never put /usr/include in explicitly
    $1=
  fi
fi
# Plug -I in front of it
if test -n "$[$1]"; then
  $1="-I$[$1]"
fi
test -n "$verbose" && echo "	setting $1 to [$]$1"
AC_SUBST($1)])dnl
dnl
dnl Look for X11 include files.  If not in /usr/include, substitute for
dnl xincdir and xlibdir.
dnl
define(ACAUX_X11_INCLUDES,
[AC_PROVIDE([$0])
if test -z "$xincdir"; then
  echo checking for X11 headers
  dir=""
  AC_TEST_CPP([#include <X11/Xlib.h>],:,
    for d in /usr/local/include \
             /usr/include/X11R5 \
             /usr/include/X11R4 \
             /usr/lpp/X11/Xamples/include \
             /usr/X11/include \
             /usr/X11R5/include \
             /usr/openwin/include \
             /usr/openwin/share/include \
             /usr/include; do
      echo checking for X11 headers in "$d"
      if test -f "$d/X11/Xlib.h"; then
        dir="$d"
	break
      fi
    done
  if test -z "$dir"; then
    cat << EOM
This package requires X11 header files but I could not find them.
Please set the environment variable xincdir to the directory containing
the <X11/...> include hierarchy and rerun configure.
EOM
    exit 1
  fi
  xincdir=$dir
  )
  if test -z "$xincdir" || test "$xincdir" = "/usr/include"; then
    xincdir=
    if test -f /usr/include/mit/X11/Xlib.h; then
      AC_COMPILE_CHECK("broken X11 header files",
[#include <X11/Xlib.h>
#include <X11/Xutil.h>],
[XSizeHints* size;],
:,
      echo "	using /usr/include/mit"
      xincdir=/usr/include/mit)
    fi
  fi
else
  if test ! -f "$xincdir/X11/Xlib.h"; then
    cat << EOM
$xincdir does not contain X11/Xlib.h.  Set the environment variable
\"xincdir\" correctly and rerun configure.
EOM
    exit 1
  fi
fi
if test ! -z "$xincdir"; then
  xincdir=-I"$xincdir"
fi
AC_SUBST(xincdir)])dnl
dnl
dnl Check for X11 libraries.
dnl
define(ACAUX_X11_LIBRARIES,
[AC_PROVIDE([$0])
AC_REQUIRE([ACAUX_X11_INCLUDES])
if test -z "$xlib"; then
  dir=
  for d in /usr/lib \
           /usr/local/lib \
           /usr/lib/X11R5 \
           /usr/lib/X11R4 \
           /usr/lpp/X11/Xamples/lib \
           /usr/X11/lib \
           /usr/X11R5/lib \
           /usr/openwin/lib; do
    echo checking for "$d/libX11.a"
    if test -f "$d/libX11.a"; then
       dir="$d"
       break
    fi
  done

  # Handle case where /usr/lib/libX11 does not exist, but fixed Ultrix
  # library exists.
  if test -z "$dir" && test "$xincdir" = "-I/usr/include/mit" && test -f "/usr/lib/libX11-mit.a"; then
    dir="/usr/lib"
  fi

  if test -z "$dir"; then
    cat << EOM
This package requires the X11 library but I could not find it.
Please set the environment variable xlib to contain a linker specification
for the X11 library and rerun configure.  E.g. xlib="-L/usr/foo/lib -lX11".
EOM
    exit 1
  fi
  if test "$dir" = "/usr/lib"; then
    xlib="-lX11"
  else
    xlib="-L$dir -lX11"
  fi

  # Check for broken Ultrix library
  if test "$xlib" = "-lX11" && test "$xincdir" = "-I/usr/include/mit" && test -f "/usr/lib/libX11-mit.a"; then
    echo "	using -lX11-mit"
    xlib="-lX11-mit"
  fi
fi
AC_SUBST(xlib)])dnl
