#
# 
#  Copyright (c) 1994 A & A Custom Software.
#  All rights reserved.
# 
#  Redistribution and use in source and binary forms, with or without
#  modification, are permitted provided that the following conditions
#  are met:
#  1. Redistributions of source code must retain the above copyright
#     notice, this list of conditions and the following disclaimer.
#  2. Redistributions in binary form must reproduce the above copyright
#     notice, this list of conditions and the following disclaimer in the
#     documentation and/or other materials provided with the distribution.
#  3. All advertising materials mentioning features or use of this software
#     must display the following acknowledgement:
#       This product includes software developed by A & A Custom Software 
#       and its contributors.
#  4. Neither the name of A & A Custom Software nor the names of its 
#     contributors may be used to endorse or promote products derived from this 
#     software without specific prior written permission.
# 
#  THIS SOFTWARE IS PROVIDED BY A & A CUSTOM SOFTWARE AND CONTRIBUTORS ``AS IS''
#  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
#  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
#  ARE DISCLAIMED.  IN NO EVENT SHALL A & A CUSTOM SOFTWARE OR CONTRIBUTORS BE 
#  LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
#  CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
#  SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
#  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
#  CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
#  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
#  POSSIBILITY OF SUCH DAMAGE.
# 
# $Id: rolodex.t,v 1.2 1994/05/20 17:24:37 andy Exp $
#
# Make a rolodex-like window for user to choose a fax number.
#


proc rolodex { t w } {

    global phonedb 
    global phonelist

    # If the cache was not initialized, initialize it.
    if {[ff_checkCacheDB $phonedb phonelist]} {
	return
    }

    catch {destroy $t}
    toplevel $t

    set fn {*courier*bold-r*12*}

    wm title $t "FAX Numbers"
    wm minsize $t 275 250

    global clen
    global plen
    global nlen

    ut_mkFrame $t {f {} {} c {-relief flat} {bottom fillx}}
    set style "%-${nlen}.${nlen}s  %-${clen}.${clen}s  %${plen}.${plen}s"
    set hdr [format "$style" "Name" "Company" "Phone"]
    set hdr_attr [list $hdr -font $fn -padx 20] 
    ut_mkLabel $t.f [list l_rolodex $hdr_attr {top fillx padx 20}]

    scrollbar $t.f.scr -relief sunken -command "$t.f.bx yview"
    listbox $t.f.bx -yscroll "$t.f.scr set" -relief sunken -font $fn
    ut_mkButton $t.c [list b_cancel "DISMISS -command \{destroy $t\}"]
    ut_mkButton $t.c [list b_rescan "RESCAN -command \{rescan_cb $t\}"]
    pack append $t.f $t.f.scr {left filly} $t.f.bx {right fill expand}
    tk_listboxSingleSelect $t.f.bx
    bind $t.f.bx <B1-ButtonRelease> "phone_cb $t $w" 

    set l [lsort [array names phonelist]]
    foreach i $l {
	set company [lindex $phonelist($i) 0]
	set phone [lindex $phonelist($i) 1]
	set entry [format "$style" $i $company $phone]
	$t.f.bx insert end $entry
    }

}

proc rescan_cb { t } {

    global phonelist
    global phonedb
    global clen
    global plen
    global nlen

    # If the cache was not initialized, initialize it.
    if {[ff_checkCacheDB $phonedb phonelist]} {
	return
    }

    # Remove whats already in the listbox
    $t.f.bx delete 0 end

    set style "%-${nlen}.${nlen}s  %-${clen}.${clen}s  %${plen}.${plen}s"

    set l [lsort [array name phonelist]]
    foreach i $l {
	set company [lindex $phonelist($i) 0]
	set phone [lindex $phonelist($i) 1]
	set entry [format "$style" $i $company $phone]
	$t.f.bx insert end $entry
    }
}

proc phone_cb { t w } {

    global clen
    global plen
    global nlen

    set idx [$t.f.bx curselection]
    set entry [$t.f.bx get $idx]
    # Extract the name, company and phone from the selected item.
    set name [string trim [string range $entry 0 $nlen]]
    ut_updateEntry $w.e_name $name 

    set start [expr $nlen+1]
    set end [expr $nlen+$clen]
    set company [string trim [string range $entry $start $end]]
    ut_updateEntry $w.e_company $company 

    set start [expr $nlen+$clen+1]
    set phone [string trim [string range $entry $start end]] 
    ut_updateEntry $w.e_phone $phone 

    # Remove highlight
    $t.f.bx select clear
}
