proc graph {cv cmd args} {
    switch $cmd {
	create {
	    set kind [lindex $args 0]
	    set i [uplevel $cv create $args ]
	    if {[lsearch {edge bitmap oval polygon rectangle text window} $kind] < 0} {
		error "cannot layout items of type $kind"
	    } else {uplevel $cv graph add $i}
	    return $i
	}
	delete {
	    set i [lindex $args 0]
	    uplevel $cv graph remove $i
	    uplevel $cv delete $args
	}
	destroy {
	    foreach e [uplevel $cv graph edges] {
		uplevel $cv graph remove $e
		uplevel $cv delete $e
	    }
	    foreach n [uplevel $cv graph nodes] {
		uplevel $cv graph remove $n
		uplevel $cv delete $n
	    }
	    uplevel $cv graph destroy
	    uplevel destroy $cv
	}
	default {uplevel $cv graph $cmd $args}
    }
}

proc sortnodes {cv {sortcmd "lsort -decreasing"}} {
    set nodelist [uplevel $cv graph nodes]
    set edgelist [uplevel $cv graph edges]
    uplevel $cv graph clear
    set sortednodelist [uplevel $sortcmd [list $nodelist]]
    uplevel $cv graph add $sortednodelist $edgelist
    return $cv
}

#global .g b1 b2 r1 o1 e1 e2 e3
set graphfont "-*-helvetica-*-r-*-*-18-*-75-75-*-*-iso8859-*"

# Define some node and edge creation routines.

# Create a node on canvas cv, with a label, and position initially at (x,y)

proc newnode {cv nodename {label ""} {x 0} {y 0}} {
    global graphfont
    if {$label == ""} {set label $nodename}
    button $cv.$nodename -text $label \
		-background lightblue \
		-relief groove \
		-font $graphfont
    set n [graph $cv create window $x $y -window $cv.$nodename \
		-anchor nw -tag $nodename]
    return $n
}

# Create an edge on canvas cv, with a label,
# and connecting nodes src and dst

proc newedge {cv edgename src dst {label ""}} {
    global graphfont
    set e [graph $cv create edge -1m -1m -1m -1m -from $src -to $dst \
	-tag $edgename -arrow last]
    if {$label != ""} {
	$cv itemconfigure $e -label $label -font $graphfont
    }
    return $e
}


# Demonstrate simple use of the package.

proc tklayoutdemo {} {
    global tk_library
    # create scrolled canvas
    canvas .g \
	-scrollregion {-100m -100m 100m 100m} \
	-width 100m -height 100m \
	-xscroll ".hscroll set" -yscroll ".vscroll set"
    scrollbar .vscroll  -relief sunken -command ".g yview"
    scrollbar .hscroll -orient horiz -relief sunken -command ".g xview"
    pack .hscroll -side bottom -fill x
    pack .vscroll -side right -fill y
    pack .g -expand yes -fill both

    # create some nodes using newnode
    newnode .g button1 "" 50m 50m
    newnode .g button2 "" 20m 20m
    # and some nodes using more direct methods
    set r1 [graph .g create rectangle 75m 75m 85m 85m -fill red]
    set o1 [graph .g create oval 90m 90m 100m 100m -fill green]
    set t1 [graph .g create text 80m 90m -text textitem -fill blue -anchor nw]
    set p1 [graph .g create polygon 0m 75m 10m 65m 10m 85m -fill black]
    #following assumes the demo is run in the main tk3.6 directory
    set m1 [graph .g create bitmap 75m 10m \
		-bitmap @$tk_library/demos/bitmaps/face ]
    # create some edges
    newedge .g e1 button1 button2
    newedge .g e2 button1 $r1
    newedge .g e3 $o1 $t1
    newedge .g e4 button2 $p1
    newedge .g e5 $p1 $m1
    puts "isi layout"
    graph .g layout isi
    update
    after 2500
    puts "tree layout"
    graph .g layout tree
    update
    after 2500
    puts "random layout"
    graph .g layout random
    update
    after 2500
    puts "matrix layout (nodes sorted by decreasing id, and edges hidden)"
    sortnodes .g
    graph .g configure -hideedges 1
    graph .g layout matrix
    update
    after 2500
    puts "destroying graph"
    graph .g destroy
    destroy .vscroll
    destroy .hscroll
}
