# ftp.tcl
#----------------------------------------------------------------------------
# Copyright 1994 Siemens KWU Erlangen
# Permission to use, copy, modify, and distribute this documentation
# is hereby granted, provided that this copyright notice appears
# in all copies. This software is provided without any warranty, express
# or implied. Siemens KWU Erlangen makes no representations about the
# suitability of this software for any purpose.
#
# Author: Johan Lindbladh (tet90jl@tintin.hik.se)
#----------------------------------------------------------------------------
# This script generates a window with the  possibility to include a reference
# to a file stored in a ftp that require a valid login
#----------------------------------------------------------------------------

#----------------------------------------------------------------------------
#### proc wrapftp ####
#----------------------------------------------------------------------------
proc wrapftp {} {
destroy .ftp
}

#----------------------------------------------------------------------------
#### proc includeftp ####
# Include a file stored in a ftp and updates the mainwindow
#----------------------------------------------------------------------------
proc includeftp {contentname transfermode filename domainname \
	directoryname} {
global breakpoint
global currenttext
global winnumber
global sumofwin
global includenum
global currentwidgetnumber
global widgetname
global contenttype
global body
global description
global bg1 bg2 actbg bheight

set sumofwin [expr $sumofwin+1]
set includenum [expr $includenum+1]
set currentframe [split $currenttext .]
set part2 [lindex $currentframe 2]
set currentframe .[lindex $currentframe 1]
## Checks if cursor doesn't stand in an textfield, then the input will be first
if {$part2 !="text"} {
   set currenttext $widgetname(1)
   set currentframe [split $currenttext .]
   set currentframe .[lindex $currentframe 1]
   set breakpoint 1.0
   }
frame .f$includenum -background $bg1
#### if first position in the current textwidget
if {$breakpoint=="1.0"} {
   pack .f$includenum -fill both -side top -before $currentframe
   canvas .f$includenum.canvas -background $bg1 -relief raised -height 20
   pack .f$includenum.canvas -fill x
   updatesendlist $currentwidgetnumber($currenttext) $sumofwin
   set currentwidgetnumber(.f$includenum.canvas) \
        [expr $currentwidgetnumber($currenttext)-1]
   set widgetname($currentwidgetnumber(.f$includenum.canvas)) .f$includenum.canvas
   set contenttype($currentwidgetnumber(.f$includenum.canvas)) \
        "\[SafeTcl_makebody \"message/external-body\" "
   set body($currentwidgetnumber(.f$includenum.canvas)) \
        "-parameter \"\\n access-type=\\\"ftp\\\"\" \
 -parameter \"\\n name=\\\"$filename\\\"\" \
 -parameter \"\\n site=\\\"$domainname\\\"\" \
 -parameter \"\\n directory=\\\"$directoryname\\\"\" \
 -parameter \"\\n mode=\\\"$transfermode\\\"\" \
\"Content-type:  $contentname\" \] " 
   set description($currentwidgetnumber(.f$includenum.canvas)) \
        "Ftp: $domainname, $directoryname/$filename, $contentname"
   # # # # #
} else {
   pack .f$includenum -fill both -side top -after $currentframe
   text .f$includenum.text -relief raised -bd 2 -background $bg2 \
        -yscrollcommand ".f$includenum.scroll set" -height $bheight
   scrollbar .f$includenum.scroll  -relief flat  -background $bg2 -foreground \
        $bg2 -activeforeground $actbg -command ".f$includenum.text yview"
   pack .f$includenum.scroll -side right -fill y
   pack .f$includenum.text -expand yes -fill both
   .f$includenum.text insert 1.0 [ $currenttext get insert end]
   $currenttext delete insert end
   updatesendlist [expr $currentwidgetnumber($currenttext)+1] $sumofwin

   set currentwidgetnumber(.f$includenum.text) \
        [expr $currentwidgetnumber($currenttext)+1]
   set widgetname($currentwidgetnumber(.f$includenum.text)) .f$includenum.text
   set contenttype($currentwidgetnumber(.f$includenum.text)) \
        "\[SafeTcl_makebody \"text/plain\" "
   set body($currentwidgetnumber(.f$includenum.text)) \
        "\[.f$includenum.text get 1.0 end\]\] "
   set description($currentwidgetnumber(.f$includenum.text)) \
        "textfield"
   set sumofwin [expr $sumofwin+1]
   set includenum [expr $includenum+1]
   frame .f$includenum -background $bg1
   pack .f$includenum -fill both -side top -after $currentframe
   canvas .f$includenum.canvas -background $bg1 -relief raised -height 20
   pack .f$includenum.canvas -fill x

   set currentwidgetnumber(.f$includenum.canvas) [expr \
        $currentwidgetnumber($currenttext)+1]
   updatesendlist [expr $currentwidgetnumber($currenttext)+1] $sumofwin
   set widgetname($currentwidgetnumber(.f$includenum.canvas)) \
	.f$includenum.canvas
   set contenttype($currentwidgetnumber(.f$includenum.canvas)) \
        "\[SafeTcl_makebody \"message/external-body\" "
   set body($currentwidgetnumber(.f$includenum.canvas)) \
        "-parameter \"\\n access-type=\\\"ftp\\\"\" \
 -parameter \"\\n name=\\\"$filename\\\"\" \
 -parameter \"\\n site=\\\"$domainname\\\"\" \
 -parameter \"\\n directory=\\\"$directoryname\\\"\" \
 -parameter \"\\n mode=\\\"$transfermode\\\"\" \] "
   set description($currentwidgetnumber(.f$includenum.canvas)) \
        "Ftp: $domainname, $directoryname/$filename, $contentname"
   }
.f$includenum.canvas create text 1 10 -text "Ftp: $domainname, \
	$directoryname/$filename, $contentname" -anchor w
destroy .ftp
.butt.label configure -text "Including a reference to an ftp server...done " \
	-foreground #000000
}



#----------------------------------------------------------------------------
#### proc ftp ####
# Creates a window which gives the user the possibility to include 
# file stored external in a ftp that require a valid login
#----------------------------------------------------------------------------
proc ftp {} {
global breakpoint
global currenttext
global domainarray
global numberofdomains
global ftpdirectory
global numberofftpdir
global type
global numberoftype
global transfer
global numberoftransfer
global bg1 bg2 actbg

.butt.label configure -text "Including a reference to an ftp server..." \
	-foreground #3d55ff
toplevel .ftp
wm title .ftp "Ftp"
wm iconname .ftp "Ftp"

# set contentname message/external-body
# set transfermode ascii

#----------------------------------------------------------------------------
# Pack the the labels and the entries in widget .ftp
#---------------------------------------------------------------------------- 
label .ftp.header1 -text "A reference to a ftp" -background $bg1 \
        -font "-*-helvetica-*-r-*-*-*-240-*-*-*-*-*-*" -foreground red
label .ftp.header2 -text "Please give the following options" -background \
	$bg1
pack .ftp.header1 -side top -fill x
pack .ftp.header2 -side top -fill x

#----------------------------------------------------------------------------
# Pack the menu and entry for the domain
#----------------------------------------------------------------------------
frame .ftp.f2 -background $bg2
pack .ftp.f2 -fill both

menubutton .ftp.f2.domain -width 14 -text "Domainame :" -activebackground \
	$actbg -menu .ftp.f2.domain.m -background $bg1 -anchor w \
	-relief raised

menu .ftp.f2.domain.m -background $bg1 -activebackground $actbg
for {set i 1} {$i <= $numberofdomains} {incr i 1} {
  .ftp.f2.domain.m add command -label $domainarray($i) -command \
	".ftp.f2.domainname delete 0 end; .ftp.f2.domainname \
 insert 0 $domainarray($i); grab .ftp" \
       -background $bg1 -activebackground $actbg 
   }
entry .ftp.f2.domainname -width 60 -relief sunken \
        -background $bg2 -textvariable domainname
pack .ftp.f2.domain -side left -anchor w
pack .ftp.f2.domainname -side left

#----------------------------------------------------------------------------
# Pack the menu and entry for the directory
#----------------------------------------------------------------------------
frame .ftp.f4 -background $bg2
pack .ftp.f4 -fill both

menubutton .ftp.f4.directory -width 14 -text "Directory :" -background \
	$bg1 -activebackground $actbg -relief raised -anchor w \
	-menu .ftp.f4.directory.m
menu .ftp.f4.directory.m -background $bg1 -activebackground $actbg
for {set i 1} {$i <= $numberofftpdir} {incr i 1} {
  .ftp.f4.directory.m add command -label $ftpdirectory($i) -command \
	".ftp.f4.directoryname delete 0 end; .ftp.f4.directoryname \
	insert 0 $ftpdirectory($i); grab .ftp" \
	-background $bg1 -activebackground $actbg
   }
entry .ftp.f4.directoryname -width 60 -relief sunken \
        -background $bg2 -textvariable directoryname
pack .ftp.f4.directory -side left -anchor w
pack .ftp.f4.directoryname -side left

#----------------------------------------------------------------------------
# Pack the label and entry for the file
#----------------------------------------------------------------------------
frame .ftp.f1 -background $bg2
pack .ftp.f1 -fill both
label .ftp.f1.file -width 14 -text "Filename :" -background $bg1 \
	-anchor w
entry .ftp.f1.filename -width 60 -relief sunken \
        -background $bg2 -textvariable filename
pack .ftp.f1.file -side left -anchor w
pack .ftp.f1.filename -side left

#----------------------------------------------------------------------------
# Pack the menu and entry for the Content 
#----------------------------------------------------------------------------
frame .ftp.f0 -background $bg2
pack .ftp.f0 -fill both

menubutton .ftp.f0.content -width 14 -text "Content-type :" -background \
	$bg1 -activebackground $actbg -relief raised -anchor w -menu \
	.ftp.f0.content.m
menu .ftp.f0.content.m -background $bg1 -activebackground $actbg
for {set i 1} {$i <= $numberoftype} {incr i 1} { 
  .ftp.f0.content.m add command -label $type($i) -command \
	".ftp.f0.contentname delete 0 end; .ftp.f0.contentname \
	insert 0 $type($i); grab .ftp" -background $bg1 -activebackground $actbg
  }

entry .ftp.f0.contentname -width 60  -background $bg2 \
	-textvariable contentname -relief sunken 
pack .ftp.f0.content -side left -anchor w
pack .ftp.f0.contentname -side left

#----------------------------------------------------------------------------
# Pack the menu and entry for the Transfer
#----------------------------------------------------------------------------
frame .ftp.f3 -background $bg2
pack .ftp.f3 -fill both
menubutton .ftp.f3.transfer -width 14 -text "Transfer mode :" -background \
	$bg1 -activebackground $actbg -relief raised -anchor w -menu \
	.ftp.f3.transfer.m -anchor w
menu .ftp.f3.transfer.m -background $bg1 -activebackground $actbg
for {set i 1} {$i <= $numberoftransfer} {incr i 1} {
  .ftp.f3.transfer.m add command -label $transfer($i) -command \
	".ftp.f3.transfermode delete 0 end; .ftp.f3.transfermode \
	insert 0 $transfer($i); grab .ftp" -background $bg1 \
	-activebackground $actbg
  }
entry .ftp.f3.transfermode -width 60 -relief sunken -background $bg2 \
	-textvariable transfermode
pack .ftp.f3.transfer -side left -anchor w
pack .ftp.f3.transfermode -side left

#----------------------------------------------------------------------------
# Button actions
#----------------------------------------------------------------------------
frame .ftp.f -background $bg1
pack .ftp.f -fill both
button .ftp.f.include -text Include -command {includeftp $contentname \
	$transfermode $filename $domainname $directoryname} \
	-background $bg1 -activebackground $actbg
button .ftp.f.quit -text Cancel -command "wrapftp; .butt.label \
	configure -text \"Including a reference to an anon-ftp server... \
        Cancelled\" -foreground #000000" -background $bg1 \
        -activebackground $actbg
pack .ftp.f.include .ftp.f.quit -side left -expand yes -pady 5

focus .ftp.f2.domainname
grab .ftp

#----------------------------------------------------------------------------
# Bindings 
#----------------------------------------------------------------------------

bind .ftp.f2.domainname <Return> {focus .ftp.f4.directoryname}
bind .ftp.f2.domainname <Down> {focus .ftp.f4.directoryname}
bind .ftp.f4.directoryname <Up> {focus .ftp.f2.domainname}
bind .ftp.f4.directoryname <Return> {focus .ftp.f1.filename}
bind .ftp.f4.directoryname <Down> {focus .ftp.f1.filename}
bind .ftp.f1.filename <Up> {focus .ftp.f4.directoryname}
bind .ftp.f1.filename <Return> {focus .ftp.f0.contentname}
bind .ftp.f1.filename <Down> {focus .ftp.f0.contentname}
bind .ftp.f0.contentname <Up> {focus .ftp.f1.filename}
bind .ftp.f0.contentname <Return> {focus .ftp.f3.transfermode}
bind .ftp.f0.contentname <Down> {focus .ftp.f3.transfermode}
bind .ftp.f3.transfermode <Up> {focus .ftp.f0.contentname}
bind .ftp.f3.transfermode <Return> {focus .ftp.f3.transfermode}
}
