# mailserver.tcl
#----------------------------------------------------------------------------
# Copyright 1994 Siemens KWU Erlangen
# Permission to use, copy, modify, and distribute this documentation
# is hereby granted, provided that this copyright notice appears
# in all copies. This software is provided without any warranty, express
# or implied. Siemens KWU Erlangen makes no representations about the
# suitability of this software for any purpose.
#
# Author: Johan Lindbladh (tet90jl@tintin.hik.se)
#----------------------------------------------------------------------------
# This script generates a window with the  possibility to include a reference
# to a file stored in an anonymous ftp
#----------------------------------------------------------------------------

#----------------------------------------------------------------------------
#### proc wrapmailserv 
#----------------------------------------------------------------------------
proc wrapmailserv {} {
destroy .mailserv
}

#----------------------------------------------------------------------------
#### proc includemailserv ####
# Include a file stored external that will be transmitted with help of
# a mailserver that will send the data on request. The procedure will
# also update the mainwindow.
#----------------------------------------------------------------------------
proc includemailserv {servername contentname mailbody} {
global breakpoint
global currenttext
global winnumber
global includenum
global sumofwin
global currentwidgetnumber
global widgetname
global contenttype
global body
global description
global bg1 bg2 actbg bheight

set sumofwin [expr $sumofwin+1]
set includenum  [expr $includenum+1]
set currentframe [split $currenttext .]
set part2 [lindex $currentframe 2]
set currentframe .[lindex $currentframe 1]
## Checks if cursor doesn't stand in an textfield, then the input will be first
if {$part2 !="text"} {
   set currenttext $widgetname(1)
   set currentframe [split $currenttext .]
   set currentframe .[lindex $currentframe 1]
   set breakpoint 1.0
   }

frame .f$includenum -background $bg1
#### if first position in the current textwidget
if {$breakpoint=="1.0"} {
   pack .f$includenum -fill both -side top -before $currentframe
   canvas .f$includenum.canvas -background $bg1 -relief raised -height 20
   pack .f$includenum.canvas -fill x
   updatesendlist $currentwidgetnumber($currenttext) $sumofwin
   set currentwidgetnumber(.f$includenum.canvas) \
        [expr $currentwidgetnumber($currenttext)-1]
   set widgetname($currentwidgetnumber(.f$includenum.canvas)) .f$includenum.canvas
   set contenttype($currentwidgetnumber(.f$includenum.canvas)) \
        "\[SafeTcl_makebody \"message/external-body\" "
   set body($currentwidgetnumber(.f$includenum.canvas)) \
        "-parameter \"\\n access-type=\\\"mail-server\\\"\" \
 -parameter \"\\n server=\\\"$servername\\\"\" \
 \[SafeTcl_makebody \"$contentname\" \
 \"$mailbody\"\]\] "
   set description($currentwidgetnumber(.f$includenum.canvas)) \
        "Mailserver $servername, $contentname"
   # # # # #
} else {
   pack .f$includenum -fill both -side top -after $currentframe
   text .f$includenum.text -relief raised -bd 2 -background $bg2 \
        -yscrollcommand ".f$includenum.scroll set" -height $bheight
   scrollbar .f$includenum.scroll  -relief flat  -background $bg2 -foreground \
        $bg2 -activeforeground $actbg -command ".f$includenum.text yview"
   pack .f$includenum.scroll -side right -fill y
   pack .f$includenum.text -expand yes -fill both
   .f$includenum.text insert 1.0 [ $currenttext get insert end]
   $currenttext delete insert end
   updatesendlist [expr $currentwidgetnumber($currenttext)+1] $sumofwin

   set currentwidgetnumber(.f$includenum.text) \
        [expr $currentwidgetnumber($currenttext)+1]
   set widgetname($currentwidgetnumber(.f$includenum.text)) .f$includenum.text
   set contenttype($currentwidgetnumber(.f$includenum.text)) \
        "\[SafeTcl_makebody \"text/plain\" "
   set body($currentwidgetnumber(.f$includenum.text)) \
        "\[.f$includenum.text get 1.0 end\]\] "
   set description($currentwidgetnumber(.f$includenum.text)) \
        "textfield"
   set sumofwin [expr $sumofwin+1]
   set includenum [expr $includenum+1]
   frame .f$includenum -background $bg1
   pack .f$includenum -fill both -side top -after $currentframe
   canvas .f$includenum.canvas -background $bg1 -relief raised -height 20
   pack .f$includenum.canvas -fill x

   set currentwidgetnumber(.f$includenum.canvas) [expr \
        $currentwidgetnumber($currenttext)+1]
   updatesendlist [expr $currentwidgetnumber($currenttext)+1] $sumofwin
   set widgetname($currentwidgetnumber(.f$includenum.canvas)) \
	.f$includenum.canvas
   set contenttype($currentwidgetnumber(.f$includenum.canvas)) \
        "\[SafeTcl_makebody \"message/external-body\" "
   set body($currentwidgetnumber(.f$includenum.canvas)) \
        "-parameter \"\\n access-type=\\\"mail-server\\\"\" \
 -parameter \"\\n server=\\\"$servername\\\"\" \
 \[SafeTcl_makebody \"$contentname\" \
 \"$mailbody\"\]\] "
   set description($currentwidgetnumber(.f$includenum.canvas)) \
        "Mailserver $servername, $contentname"
   }
.f$includenum.canvas create text 1 10 -text \
	"Mailserver $servername, $contentname" -anchor w
destroy .mailserv
.butt.label configure -text "Including a reference to a mailserver...done " \
        -foreground #000000
}




#----------------------------------------------------------------------------
#### proc mailserv ####
#----------------------------------------------------------------------------
proc mailserv {} {

global mailserver
global numberofmailserver
global type
global numberoftype
global breakpoint
global currenttext
global bg1 bg2 actbg

.butt.label configure -text "Including a reference to a mailserver..." \
	-foreground #3d55ff
toplevel .mailserv
wm title .mailserv "Mailserver"
wm iconname .mailserv "Mailserv"

set contentname message/external-body
set transfermode ascii

label .mailserv.header1 -text "Under the Control of a mailserver" \
	-background $bg1 \
        -font "-*-helvetica-*-r-*-*-*-240-*-*-*-*-*-*" -foreground red
label .mailserv.header2 -text "Please give the following options" -background \
	$bg1
pack .mailserv.header1 -side top -fill x
pack .mailserv.header2 -side top -fill x

#----------------------------------------------------------------------------
# Pack the menu and entry for the mailaddress
#----------------------------------------------------------------------------
frame .mailserv.f2 -background $bg2
pack .mailserv.f2 -fill both
menubutton .mailserv.f2.mailserveraddr -width 14 -text "Mailserveraddr :" \
	-background $bg1 -activebackground $actbg  -relief raised -menu \
	.mailserv.f2.mailserveraddr.m -anchor w
menu .mailserv.f2.mailserveraddr.m -background $bg1 -activebackground $actbg
for {set i 1} {$i <= $numberofmailserver} {incr i 1} {
  .mailserv.f2.mailserveraddr.m add command -label $mailserver($i) -command \
  ".mailserv.f2.servername delete 0 end; .mailserv.f2.servername \
 insert 0 $mailserver($i); grab .mailserv" \
       -background $bg1 -activebackground $actbg
   }

entry .mailserv.f2.servername -width 80 -relief sunken \
        -background $bg2 -textvariable servername
pack .mailserv.f2.mailserveraddr -side left -anchor w
pack .mailserv.f2.servername -side left 

#----------------------------------------------------------------------------
# Pack the label and entry for the content
#----------------------------------------------------------------------------
frame .mailserv.f0 -background $bg2
pack .mailserv.f0 -fill both

menubutton .mailserv.f0.content -width 14 -text "Content-type :" -background \
	$bg1 -activebackground $actbg -relief raised -menu \
	.mailserv.f0.content.m -anchor w
menu .mailserv.f0.content.m -background $bg1 -activebackground $actbg
for {set i 1} {$i <= $numberoftype} {incr i 1} {
  .mailserv.f0.content.m add command -label $type($i) -command \
  ".mailserv.f0.contentname delete 0 end; .mailserv.f0.contentname insert \
  0 $type($i); grab .mailserv" \
	-background $bg1 -activebackground $actbg
  }
entry .mailserv.f0.contentname -width 80  -background $bg2 \
	-textvariable contentname -relief sunken 
pack .mailserv.f0.content -side left -anchor w
pack .mailserv.f0.contentname -side left

#----------------------------------------------------------------------------
# Button actions
#----------------------------------------------------------------------------
frame .mailserv.f -background $bg1
pack .mailserv.f -fill both -side bottom
button .mailserv.f.include -text Include -command {includemailserv \
	$servername $contentname [.mailserv.text get 1.0 end]} \
	-background $bg1 -activebackground $actbg
button .mailserv.f.quit -text Cancel -command "wrapmailserv; .butt.label \
	configure -text \"Including a reference to a mailserver...Cancelled\" \
	-foreground #000000" -background $bg1 -activebackground $actbg

pack .mailserv.f.include .mailserv.f.quit -side left -expand yes -pady 5

#----------------------------------------------------------------------------
# pack the text for the bodypart for the mailserver
#----------------------------------------------------------------------------
label .mailserv.body -text "Type the included text here" -background $bg1 
pack .mailserv.body -side top -fill x

text .mailserv.text -relief raised -bd 2  -background $bg2 -yscrollcommand \
	".mailserv.scroll set" -height 10
scrollbar .mailserv.scroll -relief flat  -background $bg2 -foreground $bg2 \
        -activeforeground $actbg -command ".mailserv.text yview"
pack .mailserv.scroll -side right -fill y
pack .mailserv.text -expand yes -fill both
grab .mailserv

#----------------------------------------------------------------------------
# Bindings
#----------------------------------------------------------------------------
bind .mailserv.f2.servername <Return> {focus .mailserv.f0.contentname}
bind .mailserv.f0.contentname <Return> {focus .mailserv.text}
}
