/* tcl-to-c.y */

%{
#define YYSTYPE char *
#include "ttc.h"
char flex_name_1 [300] , * raw , raw_text [1000] ;
int num_procs, cmd_sub_count , var_sub_count , stkctr ;
char * quote () , * ypush () , * pass_interp_to_frame () ;
%}
%token  PROC 
%token  PROC_NAME 
%token  PROC_ARGS 
%token  RAW_TEXT 
%token  SCALAR
%token  ARRAY_NAME
     
%% /* Grammar rules and actions follow */

proc_list: 
   /*  empty  */  
   | proc_list PROC PROC_NAME {ypush(TCL_CMD,$3);} PROC_ARGS {prep_args(TCL_CMD,$5);} proc_body {ypop ();}
   ;

proc_body: 
     '{' cmd_list '}'
   | '"' cmd_list '"'
   ;

cmd_list:
     /* empty */
   | cmd_list cmd
   ;

cmd:
     cmd_name cmd_args '\n' {EVAL_AND_RESET_CMD_STR}
   | cmd_name cmd_args ';'  {EVAL_AND_RESET_CMD_STR}
   ;

cmd_name:
     field 
   ;

cmd_args:
     /*    */
   | cmd_args ' ' {strcat_onto ("cmd_str",quote(" ")) ;} field  
   ;

field: 
     /*   */
   | field field_element 
   ;

field_element:
     RAW_TEXT { strcat_onto ("cmd_str", quote($1)) ; }
   | '$' {strcat_onto ("cmd_str", quote("[list ")) ; $$ = ypush (VAR_SUB,new_frame(VAR_SUB)); prep_args(VAR_SUB);} var_sub {strcat_onto ("cmd_str",pass_interp_to_frame ($2)) ; strcat_onto ("cmd_str", quote("]")) ; }
   | '[' {strcat_onto ("cmd_str", quote("[list ")) ; $$ = ypush (CMD_SUB,new_frame(CMD_SUB)); prep_args(CMD_SUB);} cmd_sub {strcat_onto ("cmd_str",pass_interp_to_frame ($2)) ; strcat_onto ("cmd_str", quote("]")) ; } 


var_sub:
     ARRAY_NAME  {strcpy_into ("name_1",quote (flex_name_1)) ;} 
     array_index { EVAL_ARRAY_VAR ; ypop () ; }
   | SCALAR {
     strcpy_into ("name_1",quote($1)) ; 
     strcpy_into ("name_2","\"\"") ; 
     EVAL_SCALAR_VAR ;
     ypop () ;
   }
   ;

array_index:
     /*  */
   | array_index field_element {strcat_onto ("name_2",$2) ;}
   ;

cmd_sub:
   cmd_name cmd_args ']' { ypop () ; }
   ;


 
%%

#include "tcl.h"

Tcl_Interp * shared_interp ;

yyerror () {}


main () {

 yydebug = 1 ;

 shared_interp = (Tcl_Interp *) Tcl_CreateInterp () ;

 raw = (char *) calloc (100,sizeof(char)) ;

 Tcl_VarEval (shared_interp, "set fp [open source_code.a w]",NULL) ;
 Tcl_VarEval (shared_interp, "puts $fp {#include \"tclInt.h\"}",NULL) ;
 Tcl_VarEval (shared_interp, "puts $fp {char * strdup () ;\n\n}",NULL) ;
 Tcl_VarEval (shared_interp, "puts $fp {extern Tcl_Interp * interp ;\n}",NULL);


 Tcl_VarEval (shared_interp, "set tfp [open create_cmds.c w]",NULL) ;
 Tcl_VarEval (shared_interp, "puts $tfp {\n\ncreate_cmds ()}",NULL) ;
 Tcl_VarEval (shared_interp, "puts $tfp \\{\n\n",NULL) ;
 Tcl_VarEval (shared_interp, "close $tfp",NULL) ;

 yyparse () ;

 shres ();


 Tcl_VarEval (shared_interp, "close $fp ;", (char *) NULL) ; shres ();

Tcl_VarEval (shared_interp, "set tfp [open create_cmds.c a]",NULL) ;
Tcl_VarEval (shared_interp, "puts $tfp \\}\n}\n",NULL) ;
Tcl_VarEval (shared_interp, "close $tfp ;", (char *) NULL) ; shres ();

Tcl_VarEval (shared_interp, "set str [read [open source_code.a r]] ;", (char *) NULL) ; shres ();
Tcl_VarEval (shared_interp, "set tmp $str ;", (char *) NULL) ; shres ();
Tcl_VarEval (shared_interp, "regsub -all \"<begin code>\" $tmp \"{\" str ;", (char *) NULL) ;shres ();
Tcl_VarEval (shared_interp, "set tmp $str ;", (char *) NULL) ;shres ();
Tcl_VarEval (shared_interp, "regsub -all \"<end code>\"   $tmp } str ;", (char *) NULL) ;shres ();

Tcl_VarEval (shared_interp, "set fp [open source_code.b w] ;", (char *) NULL) ;shres ();
Tcl_VarEval (shared_interp, "puts $fp $str ;", (char *) NULL) ;shres ();
Tcl_VarEval (shared_interp, "close $fp ;", (char *) NULL) ;shres ();

Tcl_VarEval (shared_interp, "exec cat source_code.b create_cmds.c | cb > source_code.c", (char *) NULL) ;shres ();

}
