proc xgpl_WindowMisc { w } {
  global Xgpl

  catch {destroy $w}
  toplevel $w ; set title "Xgnuplot: Miscellaneous Options"
  wm title $w $title
  wm iconname $w $title
  wm iconbitmap $w @$Xgpl(bitmap)
  wm group $w .
  pack [frame $w.bar -relief flat] -side top -fill x -padx 2 -pady 2
     pack [button $w.bar.dismiss -text Dismiss -command "destroy $w" \
           -width 10 -borderwidth 1 -relief raised] -side left -anchor w

  pack [frame $w.top -relief flat] -side top -fill x -padx 2 -pady 4
    pack [checkbutton $w.top.tics -text "Plot tick marks inwards" \
          -width 20 -relief flat -anchor w -variable Xgpl(tics)] \
          -side left -anchor w
    pack [checkbutton $w.top.border -text "Display border" \
          -width 20 -relief flat -anchor w -variable Xgpl(border)] \
          -side left -anchor w

  pack [frame $w.s -relief flat] -side top -fill x -padx 2 -pady 4
  pack [label $w.s.size -text "Size:" -width 12 -relief flat -anchor w] \
          -side left -anchor w
    pack [entry $w.s.sizex -relief sunken -width 8 \
          -textvariable Xgpl(size:x)] -side left -anchor w -padx 2
    pack [entry $w.s.sizey -relief sunken -width 8 \
          -textvariable Xgpl(size:y)] -side left -anchor w -padx 2

  pack [frame $w.o -relief flat] -side top -fill x -padx 2 -pady 4
  pack [label $w.o.space -text "Offsets:" -width 12 \
          -relief flat -anchor w] \
          -side left -anchor w
    pack [entry $w.o.spacex1 -relief sunken -width 8 \
          -textvariable Xgpl(space:x1)] -side left -anchor w -padx 2
    pack [entry $w.o.spacex2 -relief sunken -width 8 \
          -textvariable Xgpl(space:x2)] -side left -anchor w -padx 2
    pack [entry $w.o.spacey1 -relief sunken -width 8 \
          -textvariable Xgpl(space:y1)] -side left -anchor w -padx 2
    pack [entry $w.o.spacey2 -relief sunken -width 8 \
          -textvariable Xgpl(space:y2)] -side left -anchor w -padx 2

  pack [frame $w.sm -relief flat] -side top -fill x -padx 2 -pady 4
  pack [label $w.sm.samp -text "Sampling:" -width 12 \
          -relief flat -anchor w] \
          -side left -anchor w
    pack [entry $w.sm.sampx -relief sunken -width 4 \
          -textvariable Xgpl(sampling)] -side left -anchor w -padx 2

  pack [frame $w.mid -relief flat] -side top -fill x -padx 2 -pady 4
    pack [checkbutton $w.mid.clippoints -text "Clip points" \
          -width 15 -relief flat -anchor w -variable Xgpl(clip:points)] \
          -side left -anchor w
    pack [checkbutton $w.mid.clipone -text "Clip one" \
          -width 15 -relief flat -anchor w -variable Xgpl(clip:one)] \
          -side left -anchor w
    pack [checkbutton $w.mid.cliptwo -text "Clip two" \
          -width 15 -relief flat -anchor w -variable Xgpl(clip:two)] \
          -side left -anchor w
}
