#
# $Source: /home/catless/nlfm/Working/Zircon/Development/lib/RCS/bindings.tcl,v $
# $Date: 1994/08/09 10:54:55 $
# $Revision: 1.15.1.9 $
#
proc doBindings {entry chid chan} {
    global zircon
    bind $entry <Meta-b> \
      { notIdle %W ; %W insert insert \002 ; tk_entrySeeCaret %W }
    bind $entry <Meta-o> \
      { notIdle %W ; %W insert insert \017 ; tk_entrySeeCaret %W }
    bind $entry <Meta-v> \
      { notIdle %W ; %W insert insert \026 ; tk_entrySeeCaret %W }
    bind $entry <Meta-u> \
      { notIdle %W ; %W insert insert \037 ; tk_entrySeeCaret %W }
    bind $entry <Meta-s> {
	notIdle %W
	global smiley ; %W insert insert $smiley
	tk_entrySeeCaret %W
    }
    bind $entry <Shift-Meta-S> {
	notIdle %W
	global scowl ; %W insert insert $scowl
	tk_entrySeeCaret %W
    }
    bind $entry <Control-Meta-s> {
	notIdle %W
	global wink ; %W insert insert $wink
	tk_entrySeeCaret %W
    }
    bind $entry <Meta-j> {
	notIdle %W
	if {![catch {selection get} bf] && ![string match {} $bf]} {
	    channelJoin [cleanup $bf]
	}
    }
    bind $entry <Meta-m> {
	notIdle %W
	if {![catch {selection get} bf] && ![string match {} $bf]} {
	    Message :: make [string range [cleanup $bf] 0 8]
	}
    }
    bind $entry <Meta-f> {
	notIdle %W
	if {![catch {selection get} bf] && ![string match {} $bf]} {
	    finger [string range [cleanup $bf] 0 8]
	}
    }
    bind $entry <Meta-q> "oneLiner %W ${chid}"
    bind $entry <Meta-w> {
	notIdle %W
	sendIRC WHOIS [%W get]
	%W delete 0 end
    }
    bind $entry <Shift-Meta-W> {
	notIdle %W
	sendIRC WHO [%W get]
	%W delete 0 end
    }
    bind $entry <Any-KeyPress> {
	notIdle %W
	if ![string match {} "%A"] {
	    %W insert insert %A ; tk_entrySeeCaret %W
	}
    }
    bind $entry <Delete> \
      { notIdle %W ; tk_entryBackspace %W; tk_entrySeeCaret %W }
    bind $entry <BackSpace> [bind $entry <Delete>]
    bind $entry <Control-h> [bind $entry <Delete>]
    bind $entry <Control-d> { notIdle %W ; %W delete insert }
    bind $entry <Control-u> { notIdle %W ; %W delete 0 end }
    bind $entry <Control-w> \
      { notIdle %W ; tk_entryBackword %W; tk_entrySeeCaret %W }
    bind $entry <Escape> " notIdle %W ; $chid makePalette"
    bind $entry <Meta-Return> " doMisc2 $chid %W "
    if !$zircon(ircIImode) {
	bind $entry <Return> "
	    $chid send \[$chid addToHist \[%W get\]\]
	    %W delete 0 end
	"
    } {
	bind $entry <Return> " doMisc2 $chid %W "
    }
    bind $entry <Shift-Meta-Return> "
	$chid addToHist \[set r  \[%W get\]\]
	$chid send \[strrev \$r\]
	%W delete 0 end
    "
    bind $entry <Control-Meta-Return> "
	$chid addToHist \[set r  \[%W get\]\]
	$chid send \[rot13 \$r\]
	%W delete 0 end
    "
    bind $entry <Control-c> "
	$chid addToHist \[set r  \[%W get\]\]
	$chid send \[toMorse \$r\]
	%W delete 0 end
    "
    bind $entry "<$zircon(action)>" "
	$chid action \[$chid addToHist \[%W get\]\]
	%W delete 0 end
    "
    bind $entry <Control-Return> "
	doNotice ${chan} \[$chid addToHist \[%W get\]\]
	%W delete 0 end
    "
    bind $entry <Control-p> "
	notIdle %W
	%W delete 0 end ; %W insert insert \[$chid getPrev\]
	tk_entrySeeCaret %W
    "
    bind $entry <Up> [bind $entry <Control-p>]
    bind $entry <Control-n> "
	notIdle %W
	%W delete 0 end ; %W insert insert \[$chid getNext\]
	tk_entrySeeCaret %W
    "
    bind $entry <Down> [bind $entry <Control-n>]
    bind $entry <ButtonPress-2> "
	notIdle %W
	$chid insertSelect
    "
    global bindings
    foreach b $bindings { bind $entry [lindex $b 0] [lindex $b 1] }
    foreach b [$chid bindings] { bind $entry [lindex $b 0] [lindex $b 1] }
}
