/* $Id: main.c,v 1.2 1993/06/08 06:16:07 david Exp $
 * 
 * $Log: main.c,v $
 * Revision 1.2  1993/06/08  06:16:07  david
 * Clean up.  Change to [interp library].
 *
 * Revision 1.1  1993/06/06  06:36:09  david
 * Initial revision.
 */

#include <stdio.h>
#include <tcl.h>
#include <tclHash.h>
#include "interp.h"

Tcl_Interp *interp;
Tcl_CmdBuf buffer;
int quitFlag = 0;

static char *initCmd[] = {
	"source [info library]/init.tcl;",
	"interp MainInterp;",
	"require InterpBase;",
	"InterpBase add_module_directory [interp library];",
	"InterpBase -import MainInterp InterpBase [InterpBase -get EXPORTS]",
	(char *)0
};

/*
 * These aren't declared anywhere on SunOS 4.1.2 but the man pages.
 */
extern int fputs _ANSI_ARGS_((const char *, FILE *));
extern int fflush _ANSI_ARGS_((FILE *));
extern int printf();

int main (argc, argv)
int argc;
char **argv;
{
	char line[1000], *cmd;
	int result, gotPartial, i;

	interp = Tcl_CreateInterp();
	buffer = Tcl_CreateCmdBuf();
	init_interp(interp);
	for (i = 0; initCmd[i]; i++) {
/*
 * printf("cmd: %s\n", initCmd[i]);
 * fflush(stdout);
 */
		Tcl_Eval(interp, initCmd[i], 0, NULL);
	}

	for (gotPartial = 0; ;) {
	        clearerr(stdin);
        	if (!gotPartial) {
	        	fputs("% ", stdout);
        		fflush(stdout);
	        }
        	if (fgets(line, 1000, stdin) == NULL) {
	        	if (!gotPartial) {
        			exit(0);
	        	}
        		line[0] = 0;
	        }
		cmd = Tcl_AssembleCmd(buffer, line);
		if (cmd == NULL) {
			gotPartial = 1;
			continue;
		}

		gotPartial = 0;
		result = Tcl_RecordAndEval(interp, cmd, 0);
		if (result == TCL_OK) {
			if (*interp->result != 0) {
				printf("%s\n", interp->result);
			}
			if (quitFlag) {
				Tcl_DeleteInterp(interp);
				Tcl_DeleteCmdBuf(buffer);
				exit(0);
			}
		} else {
			if (result == TCL_ERROR) {
				printf("Error");
			} else {
				printf("Error %d", result);
			}
			if (*interp->result != 0) {
				printf(": %s\n", interp->result);
			} else {
				printf("\n");
			}
		}
	}
} /* main () */
