/*
 *  -----------------------------------------------------------------
 *    Copyright 1993 D.I.S. - Universita` di Pavia - Italy
 *  -----------------------------------------------------------------
 *
 *  Permission to  use,  copy,   modify,   distribute  this  software
 *  and  its  documentation for any purpose is hereby granted without
 *  fee, provided that the above copyright  notice   appear   in  all
 *  copies   and  that both that copyright notice and this permission
 *  notice appear in supporting documentation, and that the  name  of
 *  D.I.S.   not  be  used  in advertising or publicity pertaining to
 *  distribution of the software without specific, written prior per-
 *  mission.   D.I.S.  makes no representations about the suitability
 *  of this software for any purpose.  It is provided "as is" without
 *  express or implied warranty.
 *
 *  D.I.S. DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, IN-
 *  CLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN
 *  NO EVENT SHALL D.I.S.  BE LIABLE FOR  ANY  SPECIAL,  INDIRECT  OR
 *  CONSEQUENTIAL  DAMAGES  OR  ANY DAMAGES WHATSOEVER RESULTING FROM
 *  LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION  OF  CONTRACT,
 *  NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNEC-
 *  TION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#include <tcl.h>

#include "version.h"

extern int dl_load(Tcl_Interp *interp, char *path, char *initFun);


static char dl_initCmd[] = {"
	if { [info commands unknown] == {} } {
		catch {source [info library]/init.tcl}
	}

	if { [info exists env(TCLLIBPATH)] } {
		eval lappend auto_path $env(TCLLIBPATH)
	}
"};



static int dl_loadCmd(ClientData notUsed, Tcl_Interp *interp,
		int argc, char **argv)
{
	/*
	 *	Syntax check
	 */
    if ( argc != 3 ) {
        sprintf(interp->result,
                "usage : %s <libPath> <initProc>", argv[0]);
        return TCL_ERROR;
    }

	/*	
	 *	Try to install the exstension and report success or failure
	 */
    return dl_load(interp, argv[1], argv[2]);
}


/*
 *	Application-specific initialization for dynamic loading
 */
int Tcl_AppInit(Tcl_Interp *interp)
{
	Tcl_CreateCommand(interp, "load", dl_loadCmd,
			(ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);


	Tcl_SetVar(interp, "dl_version", VERSION, TCL_GLOBAL_ONLY);

	/*
	 *	Eval Tcl init script for dynamic loader
	 */
	return Tcl_GlobalEval(interp, dl_initCmd);
}

