'\"
'\" Copyright 1989 Regents of the University of California
'\" Permission to use, copy, modify, and distribute this
'\" documentation for any purpose and without fee is hereby
'\" granted, provided that this notice appears in all copies.
'\" The University of California makes no representations about
'\" the suitability of this material for any purpose.  It is
'\" provided "as is" without express or implied warranty.
'\" 
'\" $Header: /n/picasso/users/syen/cms/doc/man/manl/RCS/dp_filehandler.l,v 1.3 1993/03/08 20:40:06 syen Exp $ SPRITE (Berkeley)
'
.\" The definitions below are for supplemental macros used in Sprite
.\" manual entries.
.\"
.\" .HS name section [date [version]]
.\"	Replacement for .TH in other man pages.  See below for valid
.\"	section names.
.\"
.\" .AP type name in/out [indent]
.\"	Start paragraph describing an argument to a library procedure.
.\"	type is type of argument (int, etc.), in/out is either "in", "out",
.\"	or "in/out" to describe whether procedure reads or modifies arg,
.\"	and indent is equivalent to second arg of .IP (shouldn't ever be
.\"	needed;  use .AS below instead)
.\"
.\" .AS [type [name]]
.\"	Give maximum sizes of arguments for setting tab stops.  Type and
.\"	name are examples of largest possible arguments that will be passed
.\"	to .AP later.  If args are omitted, default tab stops are used.
.\"
.\" .BS
.\"	Start box enclosure.  From here until next .BE, everything will be
.\"	enclosed in one large box.
.\"
.\" .BE
.\"	End of box enclosure.
.\"
.\" .VS
.\"	Begin vertical sidebar, for use in marking newly-changed parts
.\"	of man pages.
.\"
.\" .VE
.\"	End of vertical sidebar.
.\"
.\" .DS
.\"	Begin an indented unfilled display.
.\"
.\" .DE
.\"	End of indented unfilled display.
.\"
'	# Heading for Sprite man pages
.de HS
.if '\\$2'cmds'       .TH \\$1 1 \\$3 \\$4
.if '\\$2'lib'        .TH \\$1 3 \\$3 \\$4
.if '\\$2'tcl'        .TH \\$1 3 \\$3 \\$4
.if '\\$2'tk'         .TH \\$1 3 \\$3 \\$4
.if t .wh -1.3i ^B
.nr ^l \\n(.l
.ad b
..
'	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ie !"\\$3"" \{\
.ta \\n()Au \\n()Bu
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
'	# BS - start boxed text
'	# ^y = starting y location
'	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'	# VS - start vertical sidebar
'	# ^Y = starting y location
'	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'	# Special macro to handle page bottom:  finish off current
'	# box/sidebar if in box/sidebar mode, then invoked standard
'	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'	# DS - begin display
.de DS
.RS
.nf
.sp
..
'	# DE - end display
.de DE
.fi
.RE
.sp .5
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.HS dp_filehandler cmds
.BS
.SH NAME
dp_filehandler \- to handle file descriptor conditions
.sp
dp_isready \- Check if a socket has data pending
.sp
dp_update \- Process pending events and/or when-idle handlers
.sp
dp_after \- Execute a command after a certain amount of time has elapsed.
.SH SYNOPSIS
\fBdp_filehandler \fIsockId\fR ?\fImode\fR \fIcommand\fR?
.br
\fBdp_isready \fIsockId\fR
.br
\fBdp_update ?\fIidletasks\fR?
.br
\fBdp_after ms ?\fIarg1 arg2 arg3 ...\fR?
.BE
.SH DESCRIPTION
.LP

The dp_isready command checks whether \fIsockId\fP is readable or
writeable using a select(2) system call.  It returns a list of up two
boolean values (i.e., 1 or 0).  The first value specifies whether
\fIsockId\fP is readable, and the second value specifies whether
\fIsockId\fP is writeable.  For example, the tcl expression

.RS
if [lindex [dp_isready file3] 1] {MyOutput file3}
.RE

calls MyOutput if file3 is writeable.

The dp_update command is equivalent to the Tk "update" command,
except that it operates even if a connection to the X server is not
present.  See the Tk documentation on "update" for an explanation of
it's usage.

The dp_after command is equivalent to the Tk "after" command,
except that it operates even if a connection to the X server is not
present.  See the Tk documentation on "after" for an explanation of
it's usage.

The dp_filehander command allows one to specify a Tcl/Tk
\fIcommand\fR which will be evaluated whenever the file descriptor
represented by \fIsockId\fR is readable, writable, and/or has an
exceptional condition pending.  \fICommand\fR will be invoked with two
arguments appended: a single character indicating the \fImode\fR ('r',
'w', or 'e'), and the \fIsockId\fR.

A \fIsockId\fR is an identifier which represents a file descriptor.  It
is identical to the identifier manipulated by the Tcl-DP (Tcl
Distributed Programming) network connection management commands
(dp_connect, dp_shutdown, etc.).  \fISockId\fR's are also
manipulated by the read, eof, gets, puts, and close file management
commands of Tcl.

The \fImode\fR argument indicates the situations when the \fIcommand\fR
will be evaluated.  It may be any combination of the following values:

.RS
.TP
\fBr\fR
Eval \fIcommand\fR whenever there is data to be read from the
\fIsockId\fR.  The \fIcommand\fR is evaluated with two arguments
appended: \fBr\fR to indicate that data is readable on the file
descriptor, and the \fIsockId\fR, which represents the file descriptor
that is readable.  The \fIcommand\fR should read at least some data
from the \fIsockId\fR, or otherwise \fIcommand\fR will be called
continuously.

.TP
\fBw\fR
Eval \fIcommand\fR whenever data can be written to the \fIsockId\fR
without blocking.  The \fIcommand\fR is evaluated with two arguments
appended: \fBw\fR to indicate that the file descriptor is writable, and
the \fIsockId\fR, which represents the writable file descriptor.

.TP
\fBe\fR
Eval \fIcommand\fR whenever there is an exceptional condition pending
on the \fIsockId\fR.  The \fIcommand\fR is evaluated with two arguments
appended: \fBe\fR to indicate exception, and the \fIsockId\fR, which
represents the file descriptor with the exceptional condition.
.RE

If the \fImode\fR and \fIcommand\fR arguments are not specified, then
any previously specified \fIcommand\fR for the given \fIsockId\fR is
deleted.  Specifying a new \fIcommand\fR using the dp_filehandler
command will also delete any previously specified \fIcommand\fR for a
\fIsockId\fR.

.SH EXAMPLE

The following file handlers create a telnet like interface to the
sendmail process (port 25) running on the local host.  The command
"say" sends the string passed to it to sendmail.  The reply is
automatically printed on stdout by the get_remote procedure.

.DS
proc get_remote {mode fid} {
    # Exit if remote connection closed on us.
    if {[gets $fid input] == -1} {
	puts stdout "Connection closed by foreign host."
	exit
    }
    puts stdout $input
}

proc say {args} {
    global remote
    puts $remote $args;
}

set remote [lindex [dp_connect localhost 25] 0]
dp_filehandler $remote r get_remote
.DE

.SH SEE ALSO
Tcl-DP, select(2)
.SH AUTHOR
Pekka Nikander, Telecom Finland (Pekka.Nikander@ajk.tele.fi)
.br
Extended by Tim MacKenzie (tym@dibbler.cs.monash.edu.au)
.br
Further enhancements by Brian Smith (bsmith@cs.berkeley.edu)
.br
and Steve Yen (syen@cs.berkeley.edu)
