#! moat
#
# list.tcl : a simple list demo.
#

# The toplevel bulletin board

xtAppInitialize
xmBulletinBoard .top managed

#----------------------------------------------
# The mode radio selector
xmRowColumn .top.mode managed -x 200 -y 10

xmToggleButton .top.mode.single managed \
	-labelString "single selection mode" -selectColor red
xmToggleButton .top.mode.multiple managed \
	-labelString "multiple selection mode" -selectColor red
xmToggleButton .top.mode.extended managed \
	-labelString "extended selection mode" -selectColor red
xmToggleButton .top.mode.browse managed \
	-labelString "browse selection mode" -selectColor red

.top.mode setValues \
	-radioBehavior True \
	-radioAlwaysOne True

.top.mode.single disarmCallback {
	.top.list setValues -selectionPolicy single_select
}
.top.mode.multiple disarmCallback {
	.top.list setValues -selectionPolicy multiple_select
}
.top.mode.extended disarmCallback {
	.top.list setValues -selectionPolicy extended_select
}
.top.mode.browse disarmCallback {
	.top.list setValues -selectionPolicy browse_select
}

#----------------------------------------------
# The list widget

xmScrolledList .top.list managed \
	-x 10 -y 10 \
	-width 180 -visibleItemCount 5 \
	-listSizePolicy constant

.top.list singleSelectionCallback {
	puts stdout "single selection of item %item at position %item_position"
}
.top.list multipleSelectionCallback {
	puts stdout "multiple selection of item %item at position %item_position"
}
.top.list extendedSelectionCallback {
	puts stdout "extended selection of item %item at position %item_position"
}
.top.list browseSelectionCallback {
	puts stdout "browse selection of item %item at position %item_position"
}
.top.list defaultActionCallback {
	puts stdout "Default action called on item %item at position %item_position"
}

#----------------------------------------------
# The button to edit the list contens
xmRowColumn .top.edit managed \
	-x 300 -y 150 \
	-orientation horizontal
xmPushButton .top.edit.add managed -labelString "Add"
xmPushButton .top.edit.delete managed -labelString "Delete"
xmPushButton .top.edit.quit managed -labelString "Quit" \
	-background NavyBlue
xmTextField  .top.item managed \
	-x 10 -y 150 -width 280

.top.edit.quit activateCallback {exit 0}
.top.edit.add  activateCallback {
	.top.item getValues -text it
	.top.list addItem $it 0
}
.top.edit.delete activateCallback {
	.top.list getValues -selectedItems del_list
	foreach item [split $del_list ","] {
		.top.list deleteItem [string trim $item " "]
	}
}

#----------------------------------------------
# List insertion : the first elements
.top.list addItem Un 1000
.top.list addItem Deux 1000
.top.list addItem Trois 1000


#----------------------------------------------
. realizeWidget
. mainLoop
