.TH "receiver" TCL "" "TCL"
.ad b
.SH NAME
receiver - TCL script-level command that registers a TCL interpreter and makes
it available to receive commands.
.SH SYNOPSIS
.nf
.ft CW
receiver new label [portmanagerhost]
receiver destroy ipchandle
.ft R
.fi
'
.PP
.SH DESCRIPTION
.PP
This command is used by the TCL script-level programmer to make a
TCL interpreter available to receive commands from other TCL interpreters.
The handle
returned from the receiver command must be used at a later time to
destroy the receiver.
A PortManager is contacted to publish information relating
to the availability of the receiving interpreter.
'
.SS receiver new label [portmanagerhost]
.PP
The new option registers an interpreter as "label" on a PortManager.
An optional PortManager host can be included which tells the library
where to look for the PortManager program.
.PP
Parameters:
.RS 2
\fBo \fIlabel\fR - The name the interpreter will be registered under.
.br
.PP
\fBo \fIportmanagerhost\fR - This optional item is the name of the
host where the PortManager that should be contacted regarding this
destination interpreter is executing.
If portmanagerhost is not included, the PortManager on the
local machine is contacted.  
.br
.RE
.PP
Returns:
.RS 2
Returns TCL_OK if successful and TCL_ERROR if not.  If successful, the
result is a tclIPC handle that must be used with  
\fBreceiver destroy\fR.  If TCL_ERROR is returned, the result is a string
description of the problem.
.RE
'
.SS receiver destroy ipchandle
.PP
This option destroys the resources associated with the receiver and 
removes its information from the PortManager where it was registered.
.PP
Parameters:
.RS 2
\fBo \fIipchandle\fR - A valid receiver handle as returned by the 
\fBreceiver new\fR command.
.br
.RE
.PP
Returns:
.RS 2
Returns TCL_OK if successful and TCL_ERROR if not. 
.RE
'
