
/* -*-Mode: C;-*- opendb.c -[Sun Oct 11 13:05:59 1992 by cxh]- */
#ifndef lint
static char     rcsid[] = "$Id: sql.sc,v 1.4 1992/09/29 21:20:13 cxh Exp cxh $";
#endif
/*
 * Copyright 1992 Regents of the University of California. Permission to use,
 * copy, modify, and distribute this software and its documentation for any
 * purpose and without fee is hereby granted, provided that the above
 * copyright notice appear in all copies.  The University of California makes
 * no representations about the suitability of this software for any purpose.
 * It is provided 'as is' without express or implied warranty.
 */

/*
 * This file consists of the sql specific code.  This file contains embedded
 * sql, it should be converted to a .c file by Ingres' esql. The functions at
 * the bottom are externally visible.
 */

#include "tclsql.h"

/* Include the sql communications area. */
EXEC SQL INCLUDE SQLCA;

/* Include the global data location typdef. */
EXEC SQL INCLUDE SQLDA;


int             Db_open;	/* 1 if a database is open, 0 otherwise. */
char            Db_name[DBNAME_LEN];

/*
 * Open a database.  Called by SQLopendb <database_name> Allocate the generic
 * Sqlda. Return 0 if everything is ok.
 */
opendb(interp, str)
     Tcl_Interp     *interp;
     EXEC SQL BEGIN DECLARE SECTION;
     char           *str;

     EXEC SQL END DECLARE SECTION;
{
  EXEC SQL WHENEVER SQLERROR GOTO open_error;
  EXEC SQL        CONNECT:str;

  return TCL_OK;
open_error:
  sql_error(interp, "SQLopendb");
  return TCL_ERROR;
}


/*
 * Called by SQLcommit
 */
commit(interp)
     Tcl_Interp     *interp;
{
  /* Don't forget that commit closes any open cursors.*/
  EXEC SQL WHENEVER SQLERROR GOTO commit_error;
  EXEC SQL        COMMIT;
  return TCL_OK;
commit_error:
  sql_error(interp, "SQLcommit");
  return TCL_ERROR;
}
