#---------------------------------------------------------------------------
#
#	Color Settings
#
#---------------------------------------------------------------------------

global style

# Color pick {mono color}
#	Returns its first argument when the root screen is monochrome,
#	and the second argument otherwise.
#
defmethod Color-manager pick {mono color} {
  global style

  if { [winfo screendepth .] == 1 || $style(color) == "mono" } {
    return $mono
  } {
    return $color
  }
}

defobject Color Color-manager

if { [Color pick mono color] == "mono" } {
  set style(color) mono
}

case $style(color) in {
{mono} {
	#-- black and white
	set style(color) mono
	Color slot fg		black
	Color slot bg		white
	Color slot bg,button	white
	Color slot bg,dark	black
	Color slot bg,active	black
	Color slot fg,active	white
	Color slot fg,disabled	{}
	Color slot fg,alert	white
	Color slot bg,alert	black
	}
{lightblue} {
	#-- blue colors
	Color slot fg		black
	Color slot bg		#f0f0ff
	Color slot bg,button	#b0d0ff
	Color slot bg,dark	#a0c0ef
	Color slot bg,active	#e0e0ff
	Color slot fg,active	black
	Color slot fg,disabled	#808080
	Color slot fg,alert	black
	Color slot bg,alert	#e0e0ef
	}
{blue} {
	#-- blue colors
	Color slot fg		black
	Color slot bg		#40c0f0
	Color slot bg,button	#60c0ff
	Color slot bg,dark	#50b0ef
	Color slot bg,active	#c0e0ff
	Color slot fg,active	black
	Color slot fg,disabled	#808080
	Color slot fg,alert	black
	Color slot bg,alert	#e0e0ef
	}
{darkblue} {
	#-- blue colors
	Color slot fg		black
	Color slot bg		#00c8ff
	Color slot bg,button	#0098ff
	Color slot bg,dark	#0088ef
	Color slot bg,active	#00b8ff
	Color slot fg,active	black
	Color slot fg,disabled	#808080
	Color slot fg,alert	black
	Color slot bg,alert	#e0e0ef
	}
{gold} {
	#-- goldenrod colors
	Color slot fg		black
	Color slot bg		#e8c040
	Color slot bg,button	#d8b030
	Color slot bg,dark	#c8a020
	Color slot bg,active	#f8d050
	Color slot fg,active	black
	Color slot fg,disabled	#808080
	Color slot fg,alert	black
	Color slot bg,alert	#e0e0ef
	}
{steel} {
	#-- goldenrod colors
	Color slot fg		black
	Color slot bg		#c6e2ff
	Color slot bg,button	#9fb6cd
	Color slot bg,dark	#8fa6bd
	Color slot bg,active	#b9d3ee
	Color slot fg,active	black
	Color slot fg,disabled	#808080
	Color slot fg,alert	black
	Color slot bg,alert	#e0e0ef
	}
{wheat} {
	#-- wheat colors
	Color slot fg		black
	Color slot bg		#ffe7b6
	Color slot bg,button	#d1bea0
	Color slot bg,dark	#c1ae90
	Color slot bg,active	#f0dcb8
	Color slot fg,active	black
	Color slot fg,disabled	#808080
	Color slot fg,alert	black
	Color slot bg,alert	#e0e0ef
	}
{red} {
	#-- reddish colors
	Color slot fg		black
	Color slot bg		#ffb1b1
	Color slot bg,button	#ff6d6d
	Color slot bg,dark	#ef5d5d
	Color slot bg,active	#d04040
	Color slot fg,active	black
	Color slot fg,disabled	#808080
	Color slot fg,alert	black
	Color slot bg,alert	#e0e0ef
	}
{green} {
	#-- green-tone colors
	Color slot fg		black
	Color slot bg		#ceda44
	Color slot bg,button	#bac729
	Color slot bg,dark	#aab719
	Color slot bg,active	#e1f135
	Color slot fg,active	black
	Color slot fg,disabled	#808080
	Color slot fg,alert	black
	Color slot bg,alert	#e0e0ef
	}
{gray grey} {
	#-- grey tones
	Color slot fg		black
	Color slot bg		#e0e0e0
	Color slot bg,button	#c0c0c0
	Color slot bg,dark	#b0b0b0
	Color slot bg,active	#f0f0f0
	Color slot fg,active	black
	Color slot fg,disabled	#808080
	Color slot fg,alert	black
	Color slot bg,alert	#f0f066
	}
}

#if { [winfo depth .] < 24 } {
#  exec xsetroot
#  exec xsetroot -solid "#3d6493"
#}
