
proc cursor(busy) {form} {

  set windows [_cursor(enumerate) . {}]

  foreach win $windows {
    if { $win != "." } {
      lappend cursors [list $win [lindex [$win config -cursor] 4]]
      $win config -cursor watch
    }
  }

  update
  update idletasks

  if { [catch [list uplevel [list eval $form]] result] } {
    error $result
  }

  foreach cursor $cursors {
    set win [lindex $cursor 0]
    if { $win != "." && [winfo exists $win] } {
      catch [list $win config -cursor [lindex $cursor 1]]
    }
  }

  update
  update idletasks

  return $result
}

proc _cursor(enumerate) {window list} {

  lappend list $window
  foreach child [winfo children $window] {
    set list [_cursor(enumerate) $child $list]
  }
  return $list
}

