#include <stdio.h>
#include <X11/Xlib.h>
#include <gl.h>
#include <math.h>

static int bgcolor[3];

simp_clear()
{
  clear();
}

simp_init()
{
  ortho2(-0.5, 999.5, 999.5, -0.5);
}

simp_render()
{
  RGBcolor(bgcolor[0], bgcolor[1], bgcolor[2]);
  clear();
}

simp_get_mouse(ref, ret)
     char *ref;
     char *ret;
{
  Display *d;
  Window w;

  int rx, ry;
  int wx, wy;
  Window r, c;
  unsigned int m;


  if(TkGLXwin_RefGetDisplayWindow(ref, &d, &w)){
    ret[0] = '\0';
    return;
  }
  
  if(XQueryPointer(d, w, &r, &c, &rx, &ry, &wx, &wy, &m) == False){
    ret[0] = '\0';
    return;
  }

  sprintf(ret, "%d %d", wx, wy);
}

simp_render2(r, g, b)
     int r, g, b;
{
  RGBcolor(r, g, b);
  clear();
}

simp_set_RGBcolor(r, g, b)
     int r, g, b;
{
  RGBcolor(r, g, b);
}

simp_set_color(i)
     int i;
{
  color(i);
}

simp_box(x1, y1, x2, y2)
     int x1, y1, x2, y2;
{
  sboxfi(x1, y1, x2, y2);
}

simp_mapcolor(i, r, g, b)
     int i, r, g, b;
{
  mapcolor((Colorindex)i, (short)r, (short)g, (short)b);
}

simp_render_ov(i)
     int i;
{
  color(i);
  clear();
}

simp_set_value(name, val)
     char *name, *val;
{
  if(strcmp(name, "red") == 0){
    bgcolor[0] = atoi(val);
  }
  else if(strcmp(name, "green") == 0){
    bgcolor[1] = atoi(val);
  }
  else  if(strcmp(name, "blue") == 0){
    bgcolor[2] = atoi(val);
  }
}

simp_get_value(name, val)
     char *name, *val;
{
  if(strcmp(name, "red") == 0){
    sprintf(val, "%d", bgcolor[0]);
  }
  else if(strcmp(name, "green") == 0){
    sprintf(val, "%d", bgcolor[1]);
  }
  else  if(strcmp(name, "blue") == 0){
    sprintf(val, "%d", bgcolor[2]);
  }
}
