## help.tcl tkW3 help facility
## ==============
## Copyright (C) 1992-1993
## Global Network Academy
## Macvicar Institute for Educational Software Development
##
## See the file COPYRIGHT for conditions

## Conventions:
##   all global visible objects in this file should begin with 
##   tkW3Help

proc tkW3HelpInitialize {} {
    tkW3HelpCreateWhineDialog . .send_mail_dialog
}

proc tkW3HelpCreateWhineDialog {parent w} {
    global tkW3Version

    DLG:toplevel . $w
    DLG:draw_entries $w {To: Subject:}
    DLG:set_entry_value $w 1 "tk-www-bugs@athena.mit.edu"
    DLG:set_entry_value $w 2 "Comments on tkWWW Version $tkW3Version"
    
    pack append $w \
	[label $w.label \
	   -text "Please type your comments below" ] { fillx top} \
	[text $w.text ] {expand fill top}

    DLG:draw_buttons $w [list "Send Mail" "Dismiss" "Help"]
    DLG:bind_button $w 1 "wm withdraw $w ; 
    tkW3ConfigSendMail \
        \[DLG:get_entry_value $w 1\] \[DLG:get_entry_value $w 2\] \
        \[$w.text get 0.0 end\]"

    DLG:bind_button $w 2 "DLG:hide $w"
    DLG:bind_button $w 3 "tkW3HelpNoHelp"
}

proc tkW3HelpNotAvailable {} {
    DLG:information . .not_available \
	"Sorry: This feature is not available yet" "OK"
}

proc tkW3HelpAddToMailingList {} {
    tkW3OutputSetMessage "Sending request to tk-www-request@athena.mit.edu"
    tkW3ConfigSendMail tk-www-request@athena.mit.edu "Subscribe" "Add to list"
    tkW3OutputSetMessage "Request sent to tk-www-request@athena.mit.edu"
}

proc tkW3HelpRemoveFromMailingList {} {
    tkW3OutputSetMessage "Sending request to tk-www-request@athena.mit.edu"
    tkW3ConfigSendMail tk-www-request@athena.mit.edu "Remove" "Remove from list"
    tkW3OutputSetMessage "Request sent to tk-www-request@athena.mit.edu"
}

proc tkW3HelpGetTopic {topic} {
    if {$topic != "no_help"} {
	global tkW3ConfigHelpRoot
	tkW3NavigateClone $tkW3ConfigHelpRoot/$topic.html
    } {
	DLG:information . .no_help \
	    "Sorry: No help is available on this topic yet" "OK"
    }
}


proc tkW3HelpAbout {} {
    global tkW3Version
    global tkW3SourcePath
    DLG:toplevel . .information
    DLG:draw_icon_msg .information @$tkW3SourcePath/bitmap/logo "\
tkWWW Version $tkW3Version
by Joseph Wang (joe@athena.mit.edu)

Copyright \251 1992-1993
Usenet University -- Global Network Academy (UU-GNA)
Macvicar Institute for Educational Software Development

Under the terms of the GNU Public License Version 2.0

The tk-www mailing list is tk-www@athena.mit.edu
Send subscription requests to tk-www-request@athena.mit.edu
Send bug reports to tk-www-bugs@athena.mit.edu"

    DLG:draw_buttons .information "OK"
    DLG:bind_button .information 1 "DLG:destroy .information"
    DLG:show . .information
}

