## history.tcl: history for tkWWW  user interface
## ==============
## Copyright (C) 1993
## Global Network Academy
## MacVicar Institute for Educational Software Development
##
## See the file COPYRIGHT for conditions

set tkW3HistoryList {}
set tkW3HistoryOldList {}

proc tkW3HistoryInitialize {} {
}

proc tkW3HistoryRecord {title address {scroll_pos ""} {anchor ""} {ismap ""}} {
    global tkW3HistoryList tkW3HistoryOldList

    set tkW3HistoryOldList $tkW3HistoryList

    if {$title == {}} {
	set title "(Address)$address"
    }

    lappend tkW3HistoryList \
	[list $title $address {} $scroll_pos $anchor $ismap]

    tkW3MenuMakeNodeMenu .menu.history.m.history $tkW3HistoryList
}

proc tkW3HistoryRestore {} {
    global tkW3HistoryList tkW3HistoryOldList

    set tkW3HistoryList $tkW3HistoryOldList
}

proc tkW3HistoryPop {} {
    global tkW3HistoryList
    set index [expr "[llength $tkW3HistoryList]-1"] 
    set return_string [lindex $tkW3HistoryList $index ]
    incr index -1
    set tkW3HistoryList [lrange $tkW3HistoryList 0 $index]
    tkW3MenuMakeNodeMenu .menu.history.m.history $tkW3HistoryList
    return $return_string
}
