# UserMaint V1.0 by Charles A. Eads
#
# Copyright (c) 1993 The Regents of the University of California.
# All rights reserved.
# 
# Permission to use, copy, modify, and distribute this software and its
# documentation for any purpose, without fee, and without written agreement is
# hereby granted, provided that the above copyright notice and the following
# two paragraphs appear in all copies of this software.
# 
# IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY FOR
# DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
# OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE UNIVERSITY OF
# CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
# 
# THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
# INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
# AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
# ON AN "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO
# PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.

proc edit_init {w} \
{
	set index [$w.userlist.list curselection]
	if {$index == {}} return

	foreach i $index \
	{
		edit_create $w $i
	}
}

proc edit_control_create {w win} \
{
	global BACKGROUND_COLOR_ADD_EDIT
	frame $w.control -border 5 -background $BACKGROUND_COLOR_ADD_EDIT
	button $w.control.apply_changes -text "Apply Changes" -command "edit_apply_changes $w {$win}"
	button $w.control.cancel -width 13 -text "Cancel" -command "edit_finish $w {$win}"
	pack append $w.control \
		$w.control.apply_changes {left} \
		$w.control.cancel {right}
}

proc edit_create {w index} \
{
	upvar #0 window_number wnumber
	upvar #0 tmp_passwd_text([expr "{$w} == {} ? {.} : {$w}"]) tmp_passwd_text
	global group_text

	userlist_tag $w $index .edit-$wnumber

	toplevel .edit-$wnumber
	useredit_create .edit-$wnumber $w
	edit_control_create .edit-$wnumber $w

	pack append .edit-$wnumber .edit-$wnumber.useredit {top expand fill} .edit-$wnumber.control {bottom expand fill}

	set passwd_entry [file_to_normal [lindex $tmp_passwd_text $index]]
	useredit_init .edit-$wnumber \
		[passwd_get_username $passwd_entry] \
		[passwd_get_password $passwd_entry] \
		[passwd_get_uid $passwd_entry] \
		[passwd_get_gid $passwd_entry] \
		[passwd_get_gcos_field $passwd_entry] \
		[passwd_get_home_dir $passwd_entry] \
		[passwd_get_login_shell $passwd_entry]

	wm title .edit-$wnumber "EDIT:  [passwd_get_realname $passwd_entry] ([passwd_get_username $passwd_entry])"

	incr wnumber
}

proc edit_apply_changes {w win} \
{
	upvar #0 tmp_passwd_text([expr "{$win} == {} ? {.} : {$win}"]) tmp_passwd_text
	upvar #0 tmp_gid($w) tmp_gid
	global group_text

	set i [userlist_tag_find $win $w]
	if { $i != -1 } \
	{
		set user_entry [useredit_get_user_entry $w]
		if {$user_entry == -1} return
		useredit_apply $w $win
		userlist_tag_remove $win $i $user_entry $w
		userlist_tag $win $i .edited
		set passwd_entry [useredit_get_passwd_entry $w]
		set tmp_passwd_text [lreplace $tmp_passwd_text $i $i [file_to_list $passwd_entry]]
	}
	destroy $w

	follow $win.userlist.list $i 30
}

proc edit_finish {w win} \
{
	set i [userlist_tag_find $win $w]
	if { $i != -1 } \
	{
		userlist_tag_remove $win $i [userlist_get_user_entry $win $i] $w
	}
	destroy $w
}
