# Bindings to execute keybindings under different contexts


# Returns function associated with keybinding. c is character pressed.
# Events is a list of events from specific to more general
# Example: return_keybinding h {Control-h Control-Key}
proc return_keybinding {c events} {
	set cmd ""
	set fw [focus]
	set widgets [list $fw]
	lappend widgets [winfo class $fw]
	foreach w $widgets { foreach e $events {
		if {($cmd != "")} {break}
		set cmd [bind $w <$e>]
	}}
	if {($c == "\[") || ($c == "\]") || ($c == "\{") || ($c == "\}")
		|| ($c == "\(") || ($c == "\)")} {
	if {[regsub -all "%A" $cmd \"\\$c\" sub_cmd]} {set cmd $sub_cmd}
	} else {if {[regsub -all "%A" $cmd \"$c\" sub_cmd]} {set cmd $sub_cmd}}

	if {[regsub -all "%W" $cmd $fw sub_cmd]} {set cmd $sub_cmd}

	set event [lindex $events 0]
	set keysym [string range $event [expr "1+[string last - $event]"] end]
	if {[regsub -all "%K" $cmd $keysym sub_cmd]} {set cmd $sub_cmd}
	return $cmd
}

# Default number of times a command gets iterated through universal argument
# (if no value is entered)
set default_universal_number 10

proc universal_key_execute {t f n c events} {
	if {(![regexp . $c])} {return}

	destroy_f_entry $t $f.unil $f.unie
	set cmd [return_keybinding $c $events]
	if {($n == "")} {global default_universal_number ; set n $default_universal_number}
	for {set c 1} {($c <= $n)} {incr c} {eval $cmd}
}

proc uke_key {t f w k c} {
	if {([regexp \[0-9\] $c])} {$w insert end $c
	} else {universal_key_execute $t $f [$w get] $c "Key-$k Key"}
}

proc universal_key_setup {t f} {
	create_f_entry $t $f.unil $f.unie
	$f.unil configure -text "Universal Argument:"
	$f.unie configure -width 4

	bind $f.unie <Control-g> {eval [bind Text <Control-g>]}

	bind $f.unie <Key> "uke_key $t $f %W %K %A"
	bind $f.unie <Control-Key> "universal_key_execute $t $f \[%W get\] \
					%A {Control-%K Control-Key}"
	bind $f.unie <Meta-Key> "universal_key_execute $t $f \[%W get\] \
					%A {Meta-%K Meta-Key}"
	bind $f.unie <Control-Meta-Key> "universal_key_execute $t $f \[%W get\]\
					%A {Control-Meta-%K Control-Meta-Key}"
}


# Procs to send key functions to other Beth interpreters

proc do_single_keybinding {f c events} {
	catch {destroy $f.all}
	after 1 [return_keybinding $c $events]
}

# Performs function associated with keybinding in all interpreters, indluding
# this one (last).  c and events are as in return_keybinding. deiconify_flag
# if 1 sends to all interps, otherwise, just to mapped ones.
proc remote_execute_keybinding {t f deiconify_flag c events} {
	if {![regexp . $c]} {return}
	global all_status all_interps me old_focus
	if {($all_status != "permanent")} {	destroy $f.all}

	foreach interp $all_interps {
		if {($interp == $me)} {continue}
		if {(![check_interp $interp])} {continue}
		if {(![send $interp {winfo ismapped .}]) && ($deiconify_flag == 0)} {continue}
		send $interp [list do_single_keybinding $f "$c" "$events"]
	}
	focus $old_focus
	uplevel #0 [return_keybinding $c $events]
	set old_focus [focus]
	if {($all_status == "permanent")} {	focus $f.all}
}

proc toggle_all {f} {
	global all_status
	if {($all_status == "temporary")} {
		set all_status "permanent"
		set all [lindex [$f.all configure -text] 4]
		$f.all configure -text "$all Permanent"
	} else {destroy $f.all
}}

proc all_mode_setup {t f deiconify_flag} {
	if {($deiconify_flag)} {set all "All"} else {set all "All Shown"}
	global old_focus all_status
	set old_focus [focus]
	set all_status temporary
	catch {destroy $f.all}
	label $f.all -text $all
	pack append $f $f.all {left}
	focus $f.all

	bind $f.all <Meta-K> "toggle_all $f"
	bind $f.all <Meta-k> "[bind $f.all <Meta-K>]"

	bind $f.all <Key> "remote_execute_keybinding $t $f \
				$deiconify_flag %A {Key-%K Key}"
	bind $f.all <Control-Key> "remote_execute_keybinding $t $f \
				$deiconify_flag %A {Control-%K Control-Key}"
	bind $f.all <Meta-Key> "remote_execute_keybinding $t $f \
				$deiconify_flag %A {Meta-%K Meta-Key}"
	bind $f.all <Control-Meta-Key> "remote_execute_keybinding $t $f \
			$deiconify_flag %A {Control-Meta-%K Control-Meta-Key}"
}


# 'Key' bindings. f is a frame widget to put messages in.
proc keybind {f} {
	bind Text <Control-g> "+catch \{destroy_f_entry %W $f.unil $f.unie\}"

	bind Text <Meta-K> "all_mode_setup %W $f 1"
	bind Text <Meta-k> "all_mode_setup %W $f 0"
	bind Text <Control-u> "universal_key_setup %W $f"

	bind Entry <Meta-K> "all_mode_setup %W $f 1"
	bind Entry <Meta-k> "all_mode_setup %W $f 0"
}

keybind $frame
