/* PROGRAM display_command_information

Stephen O. Lidie.  June 1991.
Lehigh University Computing Center
Bethlehem, PA  18015
(215)758-3982
Stephen.O.Lidie@CDC1.CC.Lehigh.EDU
lusol@Lehigh.EDU

Copyright (C) 1991 - 1994 by Stephen O. Lidie and Lehigh University.
			 All rights reserved.

Command Source:  /usr/local/bin/disci

Message Module Name:  disci.mm

display_command_information, disci

	Displays information about a command.

	  Example:
	
	    disci -do f genpdt

        This example uses display_option full to see further information.
        Currently this additional data includes where the command was
        found and the name of the evaluate_parameters message module,
	text describing the command, as well as parameter help, if
	available.

Parameters:

-help, ?, usage_help, full_help: Display Command Information

	Display information about this command, which includes
	a command description with examples, plus a synopsis of
	the command line parameters.  If you specify -full_help
	rather than -help complete parameter help is displayed
	if it's available.

-output, o: file = stdout

	Specifies the path name of the file to receive the Display
	Command Information output.

-display_option, do: key brief, b, full, f, usage, u, keyend = D_DISCI_DO, brief

	Specifies the level of help desired.  

-do_page, dp: boolean = D_DISCI_DO_PAGE, TRUE	

	Specifies whether `display_command_information' pages help
	output.  If paging is enabled the environment variable
	MANPAGER (or PAGER) is used to control the display of the
	generated help information.  If defined and non-null, the
	value of the environment variable is taken as the name of
	the program to pipe the help output through.  If no paging
	program is defined then the program `more' is used.

	The boolean environment variable D_DISCI_DO_PAGE can be
	set to FALSE/NO/OFF/0, any case, to disable this automatic
	paging feature (or you can set your paging program to
	`cat').

Program_Name required by this command



lusol@Lehigh.EDU 94/04/08. (PDT version 2.0)  Version 2.1
  . Remove -command parameter -  the command to disci is specified via
    the trailing file_list.
  . Obey MANPAGER (or PAGER) environment variable and page help output.
    Default pager is `more'.  Since this changes the behavior of
    evaluate_parameters, the boolean environment variable D_DISCI_DO_PAGE
    or the command line parameter `do_page' can be set to FALSE/NO/OFF/0,
    any case, to disable this automatic paging.
  . Use new evaluate_parameters Help Hooks.

*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include "./evap.h"
#include "../pdt/disci_pdt_out"

static char *rcsid = {"@@(#)$Id: disci.c,v 2.1.0.1 1994/05/02 20:24:12 lusol Exp $"};

void   disci(char *command);
char   *getenv();
int    main(int argc, char *argv[]);




void disci (char * command)
{

  char   c[512+6];		/* command to disci */
  char   help[11];		/* -help or -full_help */
  char   *shell;		/* user's preferred shell */
  char   *pager;		/* page program name */

  if ( (shell = getenv("SHELL")) == NULL)
    shell = "/bin/sh";

  strcpy(help, "-?");		/* so Tcl works too */
  if ((strcmp("full", pvt[P_display_option].value.key_value) == 0) ||
        (strcmp("f", pvt[P_display_option].value.key_value) == 0))
    strcpy(help, "-full_help");
  if ((strcmp("usage", pvt[P_display_option].value.key_value) == 0) ||
        (strcmp("u", pvt[P_display_option].value.key_value) == 0))
    strcpy(help, "-usage_help");

  if (pvt[P_output].specified) { 
    sprintf(c, "%s %s > %s", command, help, pvt[P_output].value.file_value);
  } else {

    /* Establish the proper pager.  Do no paging if the boolean environment variable D_EVAP_DO_PAGE is FALSE. */

    if ( (pager = getenv( "MANPAGER" )) == NULL || (strcmp( pager, "" ) == 0) ) {
      if ( (pager = getenv( "PAGER" )) == NULL || (strcmp( pager, "" ) == 0) ) {
	pager = "more";
      }
    }
    if ( pvt[P_do_page].value.boolean_value ) {
      sprintf(c, "%s %s | %s", command, help, pager);
    } else {
      sprintf(c, "%s %s", command, help);
    }
  }	  

  putenv( "D_EVAP_DO_PAGE=FALSE" ); /* prevent possible interference from evaluate_parameters */
  execl( shell, shell, "-c", c, (char *)0 );
  _exit( 1 );

} /* end disci */




int main (int argc, char *argv[])
{

  evap_Help_Hooks[P_HHURFL] = " Program_Name\n";                                   /* Help Hook, Usage, required_file_list */
  evap_Help_Hooks[P_HHBRFL] = "\nA Program_Name is required by this command.\n\n"; /* Help Hook, Brief, required_file_list */
  evap_Help_Hooks[P_HHERFL] = "A trailing Program_Name is required by this command.\n";   /* HH, Error, required_file_list */
  evap (&argc, &argv, pdt, NULL, pvt); /* evaluate_parameters */

  if ( argc > 2 ) {
    fprintf( stderr, "disci:  please specify only one command, as in `disci disci'.\n" );
    exit( 1 );
  }

  disci( argv[1] );		/* display command information */

  exit( 0 );

} /* end display_command_information */
