/*
 * tclExtdSubset.h
 *
 * PIECES OF:
 * Standard internal include file for Extended Tcl library.
 *---------------------------------------------------------------------------
 * Copyright 1992 Karl Lehenbauer and Mark Diekhans.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appear in all copies.  Karl Lehenbauer and
 * Mark Diekhans make no representations about the suitability of this
 * software for any purpose.  It is provided "as is" without express or
 * implied warranty.
 */

#ifndef TCLEXTDINT_H
#define TCLEXTDINT_H

#include "tclInt.h"
#include "tclUnix.h"
#include <sys/param.h>

/*
 * Precompute milliseconds-per-tick, the " + CLK_TCK / 2" bit gets it to
 * round off instead of truncate.  Take care of defining CLK_TCK if its not
 * defined.
 */
#ifndef CLK_TCK
#    ifdef HZ
#        define CLK_TCK HZ
#    else
#        define CLK_TCK 60
#    endif
#endif
#define MS_PER_TICK ((1000 + CLK_TCK/2) / CLK_TCK)


#ifdef TCL_NEED_SYS_SELECT_H
#   include "sys/select.h"
#endif

/* The undef of CLK_TCK gets rid of annoying warnings on SCO unix, since
 * time.h doesn't bother to check if its defined before defining it again.
 * If tclUnix.h has already included time.h, don't include it again, some
 * systems don't #ifdef inside of the file.
 */
#ifdef TCL_NEED_TIME_H
#    if TCL_SYS_TIME_H
#        ifdef CLK_TCK
#            undef CLK_TCK
#        endif
#        include <time.h>
#    endif
#endif

/*
 * If tclUnix.h did not bring times.h, bring it in here.
 */
#if TCL_GETTOD
#    include <sys/times.h>
#endif 

#include <values.h>
#include <grp.h>
/*
 * On some systems this is not included by tclUnix.h.
 */

/*
 * These should be take from an include file, but it got to be such a mess
 * to get the include files right that they are here for good measure.
 */
struct tm *gmtime ();
struct tm *localtime ();

#ifndef MAXINT
#    define BITSPERBYTE   8
#    define BITS(type)    (BITSPERBYTE * (int)sizeof(type))
#    define HIBITI        (1 << BITS(int) - 1)
#    define MAXINT        (~HIBITI)
#endif

#ifndef MININT
#    define MININT (-MAXINT)-1
#endif

#ifndef TRUE
#    define TRUE   (1)
#    define FALSE  (0)
#endif

/*
 * Macros to do string compares.  They pre-check the first character before
 * checking of the strings are equal.
 */

#define STREQU(str1, str2) \
        ((str1[0] == str2[0]) && (strcmp (str1, str2) == 0))
#define STRNEQU(str1, str2, cnt) \
        ((str1[0] == str2[0]) && (strncmp (str1, str2, cnt) == 0))

int
Tcl_ConvertFileHandle _ANSI_ARGS_((Tcl_Interp *interp,
                                  char       *handle));

/*
 * Definitions required to initialize all extended commands.  These are either
 * the command executors or initialization routines that do the command
 * initialization.  The initialization routines are used when there is more
 * to initializing the command that just binding the command name to the
 * executor.  Usually, this means initializing some command local data via
 * the ClientData mechanism.
 */

/*
 * from clock.c
 */
extern Tcl_CmdProc  Tcl_GetclockCmd, Tcl_FmtclockCmd;



#endif
