/* 
 * Copyright (c) 1994 Open Software Foundation, Inc.
 * 
 * Permission is hereby granted to use, copy, modify and freely distribute
 * the software in this file and its documentation for any purpose without
 * fee, provided that the above copyright notice appears in all copies, and
 * that both the copyright notice and this permission notice appear in
 * supporting documentation.  Further, provided that the name of Open
 * Software Foundation, Inc. ("OSF") not be used in advertising or
 * publicity pertaining to distribution of the software without prior
 * written permission from OSF.  OSF makes no representations about the
 * suitability of this software for any purpose.  It is provided "AS IS"
 * without express or implied warranty.
 */ 

/*
 * OT 3.0.2
 */

/*
 * ot_bugs.c  -- Main for Open Track bugs database  (Query)
 *
 */

#define MAINPROGRAM

#include <string.h>
#include <ctype.h>
#include <stdio.h>
/*
#include <stdlib.h>
*/
#include <tcl.h>
#include <tclInt.h>
#include "ot.h"
#include "otInt.h"

#include "dputil.h"
#include "dpnetwork.h"

#ifndef LINT
static char RCSid_ot_bugs[] =
    "$RCSfile: ot_bugs.c,v $ $Revision: 1.1.8.3 $ $Date: 1994/01/19 17:56:06 $";
#endif

OTErr otClientQuery();


/*
 *                      m a i n
 *
 */
int
main(argc, argv, envp)
int argc;
char ** argv;
char ** envp;
{

    char *cp1;
    OTProject proj;
    FILE * pipe;

    OTErr errCode = OT_SUCCESS;
    Tcl_Interp *interp;

    OTPrivateCB *pcp;
    OTQueryCB *qcp;
    int i;

    /* If "ot_bugs -h" - just do it */

    for (i=1; i<argc; i++) {
	if ( (argv[i][0] == '-') && (strchr(argv[i], 'h')) ) {
	    otDoHelp();
	    exit(0);
	}
    }

/* Initialize TCL, control blocks, read environment variables and preparse 
   command line for project and template file names */

    if ( errCode = otInitialInit(&argc, argv) ) {
	cp1 = otGetPostedMessage();
	fprintf(stderr, "%s\n", cp1);
	exit(1);
    }
    interp = otCB->cb_pcb->pcb_interp;

    pcp = otCB->cb_pcb;
    qcp = otCB->cb_qcb;

    if (!otCB->cb_project) {
	otPutPostedMessage(OT_NEED_PROJECT);
	cp1 = otGetPostedMessage();
	fprintf(stderr, "%s\n", cp1);
	exit(1);
    }

/* Read information into Project and MetaTemplate structures, initialize TCL
   commands (call otTclInitCmds) */

    if ( errCode = otReadProject(otCB->cb_project) ) {
	cp1 = otGetPostedMessage();
	fprintf(stderr, "%s\n", cp1);
	exit(1);
    }

/* Indicate command line interface */
    otCB->cb_pcb->pcb_ui = CLI;

/* Parse command line args and set query control block values */

    if (errCode = otInitQuery()) {
	cp1 = otGetPostedMessage();
	fprintf(stderr, "%s\n", cp1);
	exit(1);
    }

    if (errCode = otParseQryArgsCLI(argc,argv)) {
	cp1 = otGetPostedMessage();
	fprintf(stderr, "%s\n", cp1);
	otCleanAfterQuery();
	exit(1);
    }
    
    if (errCode = otSetupQuery()) {
	cp1 = otGetPostedMessage();
	fprintf(stderr, "%s\n", cp1);
	exit(1);
    }

    if ( errCode = otClientQuery() ) {
        cp1 = otGetPostedMessage();
	fprintf(stderr, "%s\n", cp1);
	if ( OT_WARN(errCode) || OT_SYSTEM(errCode) )
	    exit(1);
	else
	    errCode = SUCCESS;
    }
    if ( errCode = otBringDownServer() ) {
	cp1 = otGetPostedMessage();
	fprintf(stderr, "%s\n", cp1 ? cp1 : "error in server" );
    }

    if ( qcp->qcb_sortField && pcp->pcb_sortPipe ) {
	if ( pclose(pcp->pcb_sortPipe) < 0 )
	    perror("pclose");
    }

    otCleanAfterQuery();
    otFreeControlBlock();
    exit(0);

}

/*
 * otClientQuery() - process one query
 *
 * otClientQuery() does the following:
 *  - it turns the user's .otrc (if it exists) into a string and sends it to
 *    the server (so any procedures defined there will be defined in the
 *    server)
 *  - if the user has specified an -F flag and argument, then the file it
 *    represents will be sent to the server
 *  - the current 'query context' - i.e. the result of processing the 
 *    command line arguments, including any -s argument, will be collated into
 *    a 'context' command and sent to the server
 *  - a 'query' command will be sent to the server
 *  - repeated 'query reads' get CR information in groups as determined by
 *    the server
 *  - 'query end' ends the query
 */
OTErr
otClientQuery()
{
    OTErr err = OT_SUCCESS;
    OTPrivateCB *pcp = otCB->cb_pcb;
    OTQueryCB *qcp = otCB->cb_qcb;
    OTProject *pjp;
    char prjCmd[LONGVALUE], fldCmd[LONGVALUE], qryCmd[LONGVALUE];
    char *ctxtString;
    Tcl_Interp *interp = otCB->cb_pcb->pcb_interp;
    char headingLine[LONGVALUE];
    int status, res, fd, n;
#define READBUF 32768
    char buf[READBUF];
    ClientData notUsed;
    char *sargv[4];

    headingLine[0] = 0;

    if ( err = otGenQueryContext(&ctxtString) )
	return err;

    if ( pjp = pcp->pcb_project ) {
	sprintf(prjCmd, "project set %s", pjp->name);

#ifdef notdef
	if ( status = otRemoteTcl(prjCmd) ) {
	    otPutPostedMessage(OT_GENERAL_ERROR, interp->result);
	    return OT_GENERAL_ERROR;
	}
	DBUG_MIN((stderr, "sent >> %s\n", prjCmd));
#endif

#ifdef notdef
	sprintf(fldCmd, "project fields\n");
	if ( status = otRemoteTcl(fldCmd) ) {
	    otPutPostedMessage(OT_GENERAL_ERROR, interp->result);
	    return OT_GENERAL_ERROR;
	}
	DBUG_MIN((stderr, "sent >> %s\n", fldCmd));
	if ( otCopyString( interp->result, &(pjp->server_fields)) ) {
	    otPutPostedMessage(OT_MALLOC_LOCATION, "otClientQuery()");
	    return OT_MALLOC_LOCATION;
	}
	DBUG_MIN((stderr, "received >> %s\n", pjp->server_fields));
#endif

    } else {
	otPutPostedMessage(OT_NEED_PROJECT);
	return OT_NEED_PROJECT;
    }
    
    if ( (pcp->pcb_filterNum[0]) && (!strchr(pcp->pcb_filterNum, ',')) ) {

        sprintf(qryCmd, "%s; %s; query %s\n",
	    ctxtString, prjCmd, pcp->pcb_filterNum);
        DBUG_MIN((stderr, "sent >> %s\n", qryCmd));

        if (err = otRemoteTcl(qryCmd) )
            otPutPostedMessage( OT_GENERAL_ERROR, interp->result );
        else if ( *interp->result )
            fprintf(stdout, "%s", interp->result );

	free(ctxtString);
        return err;
    }

    sprintf(qryCmd, "%s; %s; kwikQuery\n", ctxtString, prjCmd);
    if ( err = otRemoteTcl(qryCmd) ) {
	otPutPostedMessage( OT_GENERAL_ERROR, interp->result );
	free(ctxtString);
	return OT_TCL;
    }

    if ( *interp->result )
	strcpy(headingLine, interp->result);

#ifdef NOKWIK
    while ( ! OT_WARN(err) && ! OT_SYSTEM(err) ) {
	if ( err = otRemoteTcl("query next\n") ) {
	    otPutPostedMessage( OT_GENERAL_ERROR, interp->result );
	    break;
	} else if ( *interp->result ) {
	    if ( !strncmp(interp->result, "TCL error:", 10) ) {
		fprintf(stdout, "%s", interp->result );
		headingLine[0] = 0;
	    }
	    else {
		if ( headingLine[0] ) {
		    fprintf(stdout, "%s", headingLine);
		    fflush(stdout);
		    headingLine[0] = 0;
		}
		if ( qcp->qcb_sortField && pcp->pcb_sortPipe )
		    fprintf(pcp->pcb_sortPipe, "%s", interp->result);
		else
		    fprintf(stdout, "%s", interp->result);
	    }
	}
	else
	    break;
    }

    if ( err )
	otPutPostedMessage( OT_GENERAL_ERROR, interp->result );	

    if ( err = otRemoteTcl("query end\n") )
	otPutPostedMessage( OT_GENERAL_ERROR, interp->result );

    free(ctxtString);
    return err;
#endif

    sargv[0] = "dp_RDO";
    sargv[1] = pcp->pcb_fileOutName;
    sargv[2] = "kwikQuery";
    sargv[3] = "next";
    sargv[4] = 0;
    
    if ( Tdp_RDOCmd(notUsed, interp, 4, sargv) != TCL_OK ) {
	otPutPostedMessage(OT_GENERAL_ERROR, interp->result);
	err = OT_GENERAL_ERROR;
    }
    fd = fileno(pcp->pcb_fileIn->f);

    while ( (n = read(fd, buf, sizeof(buf))) > 0 ) {
	buf[n] = 0;

	/*
	 * Optimize here for first line.
	 */
        if ( (buf[0] == 'T') && !strncmp(buf, "TCL error:", 10) ) {
	    fprintf(stdout, "%s", buf);
	    headingLine[0] = 0;
	} else {
	    if ( headingLine[0] && buf[0] ) {
		fprintf(stdout, "%s", headingLine);
		fflush(stdout);
		headingLine[0] = 0;
	    }
	    if ( qcp->qcb_sortField && pcp->pcb_sortPipe )
		fprintf(pcp->pcb_sortPipe, "%s", buf);
	    else
		fprintf(stdout, "%s", buf);
	}
        if ( buf[n-1] == 0 )
	    break;
    }

    free(ctxtString);
    return err;

}
