/*
 * tmUtils.c --
 *	This module contains general purpose routines
 *	used by the Tm toolkit.
 *
 * Copyright 1993 Jan Newmarch, University of Canberra.
 * Permission to use, copy, modify, and distribute this
 * software and its documentation for any purpose and without
 * fee is hereby granted, provided that the above copyright
 * notice appear in all copies.  The author
 * makes no representations about the suitability of this
 * software for any purpose.  It is provided "as is" without
 * express or implied warranty.
 */

#include "tm.h"
#include "tmFuncs.h"

/*
 *--------------------------------------------------------------
 *
 * Tm_StoreWidgetInfo --
 *
 *	create a hash table entry for a new widget, with useful
 *	info in it.
 *
 * Results:
 *
 *	modifies hash table in "interp"
 *
 * Side effects:
 *
 *--------------------------------------------------------------
 */

void
Tm_StoreWidgetInfo(path, w, interp)
    char *path;
    Tm_Widget *w;
    Tcl_Interp *interp;
{
    int new;
    Tcl_HashEntry *hPtr;

    hPtr = Tcl_CreateHashEntry(&WidgetTable, path, &new);
    Tcl_SetHashValue(hPtr, (ClientData) w);
}


/*
 *--------------------------------------------------------------
 *
 * Tm_NameFromPath --
 *
 *	find the part of the path after the last '.'
 *
 * Results:
 *
 *	returns a pointer to the name
 *
 * Side effects:
 *
 *--------------------------------------------------------------
 */

char *
Tm_NameFromPath(pathName)
    char *pathName;
{
    char *p;

    if ((p = strrchr(pathName, '.')) == NULL) {
	return pathName;
    } else {
	return (p + 1);
    }
}



/*
 *--------------------------------------------------------------
 *
 * Tm_HiddenParentPath --
 *
 *	Create a path based on current path that cannot be duplicated
 *	actually, makes "first.last" into "first..last"
 *
 * Results:
 *
 *	returns a pointer to the name
 *
 * Side effects:
 *
 *	allocates memory
 *--------------------------------------------------------------
 */

char *
Tm_HiddenParentPath(path)
    char *path;
{
    char *p;
    char *parent;
    int len;

    p = strrchr(path, '.');
    if (p == NULL) {
        return NULL;
    }
    len = p - path + 1;

    parent = XtMalloc(strlen(path) + 2);
    strncpy(parent, path, len);
    parent[len] = '.';
    strcpy(parent + len + 1, p + 1);

    return parent;
}


/*
 *--------------------------------------------------------------
 *
 * Tm_HiddenParentPath --
 *
 *	Create a path based on current path that cannot be duplicated
 *	actually, makes "first.last" into "first..last"
 *
 * Results:
 *
 *	returns a pointer to the name
 *
 * Side effects:
 *
 *	allocates memory
 *--------------------------------------------------------------
 */

char *
Tm_ParentPath(path)
    char *path;
{
    char *p;
    char *parent;
    int len;

    p = strrchr(path, '.');
    if (p == NULL) {
        return NULL;
    }
    len = p - path;

    parent = XtMalloc(len + 1);
    strncpy(parent, path, len);
    parent[len] = '\0';

    return parent;
}

