#include <stdio.h>
#include <errno.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>

#define MAXLINE 4096        /* linelength */
#define MAXFILENAME 1024     /* length of filenames */

main(argc, argv)
int argc;
char *argv[];
{
    FILE *folder, 
         *letter;
    char line[MAXLINE], 
         filename[MAXFILENAME], 
         letterfile[MAXFILENAME], 
         elm_file[MAXFILENAME],
         *p;
    int l_length, 
        letternum,
        folnum;

 if ( argc <= 1 ) {
		Help();
		exit(0);
    }
    folnum = 1;
    while ( folnum < argc ) {
        strcpy(filename, argv[folnum++]);
        strcpy(elm_file, filename);
        strcat(elm_file, ".elm");
        if ( rename(filename, elm_file) == -1 ) {
            perror("elm2mh: rename");
            continue;
        }
        if ( mkdir(filename,00700) == -1 ) {
            perror("elm2mh: mkdir");
            continue;
        }
        folder=fopen(elm_file,"r");
        fprintf(stderr,"%s --> %s:", elm_file, filename);
        letternum = 0;
        while ( (l_length = get_line(line, folder) ) != -1 ) {
            if( (p = strstr(line, "From ")) != NULL && p == line) {
                fclose(letter); 
                letternum++;
                fprintf(stderr," %d",letternum);
                sprintf(letterfile,"%s/%d",filename,letternum);
                if ( (letter=fopen(letterfile,"w")) == NULL) {
                    fprintf(stderr,"Can't write to %s\n", letterfile);
                    continue;
                }
            }
            fprintf(letter,"%s\n",line);
        }
        fprintf(stderr,"\n");
    }
}

int get_line(line, file)
char    line[MAXLINE];
FILE    *file;
{
    register int    c;
    register int    i;

    i = 0;
    while ((c = fgetc(file)) != '\n' && c != EOF) {
        *line++ = c;
        if (++i >= MAXLINE) {
            (void)fputs("Encountered line too large.\n", stderr);
        exit(6);
        }
    }
    *line = '\0';
    if (c == EOF)
        return -1;
    return i;
}

Help()
{
    fprintf(stdout,"\nConverts Elm Folders to MH folders, searching for\n");
	fprintf(stdout,"the From field, and splitting the folder up there.\n\n");;
	fprintf(stdout,"Usage:\n");
	fprintf(stdout,"\telm2mh [foldernames]\n\n");
}

