##############################################################################
#
# help.tcl: the help function
#
# Help {{Subject {}} {Helpdir $tkmh_lib/help} {HelpList $HelpList}} 
#       Pop up a help window, displaying some help text.
#
##############################################################################

proc Help "{Subject {}} {Helpdir $tkmh_lib/help} {HelpList {$HELPLIST}}" {
    global tkmh_lib FONT BM

    set w .help
    if {![winfo exists $w]} {
      toplevel $w -class Help
      wm title $w "TkMH Help"
      wm iconbitmap $w @$BM(help)
      wm title $w "TkMH Help"
      text $w.t -yscroll "$w.s set" -wrap word -font $FONT(ProR)
      scrollbar $w.s -command "$w.t yview"
  
      frame $w.m
      button $w.m.done -text "Done" -command "destroy $w"
      menubutton $w.m.help -text "Help on" -menu $w.m.help.m
      MakeMenu $w.m.help.m $HelpList 0 {} -command {Help %EntryPath}
  
      pack append $w.m \
        $w.m.help {top expand fill} \
        $w.m.done {top expand fill}
  
      pack append $w \
        $w.t {left expand fill} \
          $w.s {left filly} \
          $w.m {left filly}
    }
    $w.t tag config TITLE -font $FONT(ProBL)
    $w.t tag config R -font $FONT(ProR) 
    $w.t tag config B -font $FONT(ProB)
    $w.t tag config I -font $FONT(ProI)
    $w.t tag config BI -font $FONT(ProBI)
    $w.t tag config T -font $FONT(FixR)

    $w.t configure -state normal
    $w.t delete 1.0 end
    if {$Subject != {}} {
      set FHandle [open $Helpdir/$Subject r]
      set state type
      foreach p [read $FHandle] {
        case $state {
          type {
            set type $p
            if {$type == "V"} {
              set type T
              set state var
            } else {
              set state text
            }
          }
          text {
            set pos [$w.t index end]
            $w.t insert end $p
            $w.t tag add $type $pos [$w.t index "end - 1 chars"]
            set state type
          }
          var {
            # In order to handle arrays correctly, this needs two arguments
            # enclosed in {}. the fist one is the array name, the second one
            # the varname. Example: V {ARRAY ARRAY(element)}
            # for normal variables repeat the entry: V {VARNAME VARNAME}
            set pos [$w.t index end]
            set ArName [lindex $p 0]
            set VarName [lindex $p 1]
            global $ArName
            $w.t insert end "[set $VarName] "
            $w.t tag add $type $pos [$w.t index "end - 1 chars"]
            set state type
          }
        }
      }
      close $FHandle
    }
    $w.t configure -state disabled
}
