# tkxpilots Version 2.0pl0 - funky interface to xpilots
# Copyright (C) 1993-1994 Richard Oak.
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

proc set_missiles {num1 num2} {
	global initialMissiles itemMissileProb itemProbMult

if {$num1 == 1} {
	set initialMissiles $num2
} else {
	set itemMissileProb $num2
}

  if {($itemProbMult == 0 || $itemMissileProb == 0) && $initialMissiles == 0} { 
		set fg gray50
		set state disabled
	} else {
		set fg black
		set state normal
	}

	.mainpanel.items.others.minsmarts.txt configure -foreground $fg
	.mainpanel.items.others.minsmarts.scale configure -foreground $fg \
		-state $state
	.mainpanel.items.check.misrad configure -foreground $fg -state $state
	.mainpanel.items.check.dismis configure -foreground $fg -state $state
}

proc set_mines {num1 num2} {
	global initialMines itemMineProb itemProbMult

if {$num1 == 1} {
	set initialMines $num2
} else {
	set itemMineProb $num2
}

        if {($itemProbMult == 0 || $itemMineProb == 0) && $initialMines == 0} {
		set fg gray50
                set state disabled
        } else {
                set fg black
                set state normal
        }

        .mainpanel.items.others.minmines.txt configure -foreground $fg
        .mainpanel.items.others.minmines.scale configure -foreground $fg \
                -state $state
	.mainpanel.items.others.minefuse.txt configure -foreground $fg
        .mainpanel.items.others.minefuse.scale configure -foreground $fg \
                -state $state
        .mainpanel.items.check.minrad configure -foreground $fg -state $state

	set_shields
}

proc set_lasers {num1 num2} {
	global initialLasers itemLaserProb itemProbMult

if {$num1 == 1} {
        set initialLasers $num2
} else {
        set itemLaserProb $num2
}

        if {($itemLaserProb == 0 || $itemProbMult == 0) && $initialLasers == 0} {
		set fg gray50
                set state disabled
        } else {
                set fg black
                set state normal
        }

	.mainpanel.items.check.lmod configure -state $state -foreground $fg
	.mainpanel.items.check.lasstn configure -state $state -foreground $fg
}

proc set_shields {} {
	global playerShielding

	if {$playerShielding == 0} {
		set fg gray50
                set state disabled
        } else {
                set fg black
                set state normal
        }

	.mainpanel.items.check.shldpu configure -state $state -foreground $fg
	.mainpanel.items.check.shldmn configure -state $state -foreground $fg
}

proc set_prob num {
	global itemProbMult initialMines initialMissiles initialLasers

	set itemProbMult $num

	if {$itemProbMult == 0} {
		set fg gray50
		set state disabled
	} else {
		set fg black
		set state normal
	}

	for {set num 2} {$num <= 16} {set num [expr $num + 1]} {
		.mainpanel.items.a.b.pr.$num configure -state $state \
			-foreground $fg
	}

	.mainpanel.items.others.moving.txt configure -foreground $fg
	.mainpanel.items.others.moving.scale configure -foreground $fg\
		-state $state
	.mainpanel.items.others.dpkill.txt configure -foreground $fg
        .mainpanel.items.others.dpkill.scale configure -foreground $fg\
                -state $state
	.mainpanel.items.others.dstcol.txt configure -foreground $fg
        .mainpanel.items.others.dstcol.scale configure -foreground $fg\
                -state $state
        .mainpanel.items.others.maxden.txt configure -foreground $fg
        .mainpanel.items.others.maxden.scale configure -foreground $fg\
                -state $state
	.mainpanel.items.others.nukeclus.txt configure -foreground $fg
        .mainpanel.items.others.nukeclus.scale configure -foreground $fg\
                -state $state
	.mainpanel.items.check.clusters  configure -foreground $fg\
                -state $state
	.mainpanel.items.check.modif configure -foreground $fg\
                -state $state
	
	set_mines 1 $initialMines
	set_missiles 1 $initialMissiles
	set_lasers 1 $initialLasers
	set_nukes
}

proc set_nukes {} {
	global allowNukes initialMines initialMissiles itemProbMult

	if {$allowNukes == 0 || $itemProbMult == 0} {
		set state disabled
		set fg gray50
		.mainpanel.items.others.minsmarts.txt configure -foreground $fg
		.mainpanel.items.others.minsmarts.scale configure -foreground $fg \
		-state $state
		.mainpanel.items.others.minmines.txt configure -foreground $fg
	        .mainpanel.items.others.minmines.scale configure -foreground $fg \
                -state $state
	} else {
		set state normal
		set fg black
		set_mines 1 $initialMines
		set_missiles 1 $initialMissiles
	}

	.mainpanel.items.others.nukeclus.txt configure -foreground $fg
	.mainpanel.items.others.nukeclus.scale configure -foreground $fg\
                -state $state
	.mainpanel.items.check.nukerad configure -foreground $fg\
                -state $state
}

proc mk_items {} {
	global movingItemProb itemProbMult maxItemDensity itemEnergyPackProb \
		itemTankProb itemECMProb itemMineProb itemMissileProb \
		itemCloakProb itemSensorProb itemWideangleProb itemRearshotProb\
		itemAfterburnerProb itemTransporterProb itemLaserProb \
		itemEmergencyThrustProb itemTractorBeamProb itemAutopilotProb \
		initialFuel initialTanks initialECMs initialMines \
		initialMissiles initialCloaks initialSensors initialWideangles \
		initialRearshots initialAfterburners initialTransporters \
		initialLasers initialEmergencyThrusts initialTractorBeams \
		initialAutopilots allowNukes allowClusters allowModifiers \
		allowLaserModifiers allowShipShapes playersOnRadar \
		missilesOnRadar minesOnRadar nukesOnRadar distinguishMissiles \
		shieldedItemPickup shieldedMining laserIsStunGun nukeMinSmarts \
		nukeMinMines nukeClusterDamage mineFuseTime crashWithPlayer \
		bounceWithPlayer playerKillings playerShielding \
		playerStartsShielded dropItemOnKillProb \
		destroyItemInCollisionProb

	set w .mainpanel.items.a.b

	frame .mainpanel.items.a

	frame .mainpanel.items.a.top
	label .mainpanel.items.a.top.1 -text "Initials"
	label .mainpanel.items.a.top.2 -text "Item"
	label .mainpanel.items.a.top.3 -text "Probabilities (x10^10)"

	pack .mainpanel.items.a.top.1 .mainpanel.items.a.top.2 \
		.mainpanel.items.a.top.3 -side left -fill both -expand yes

	frame $w

	frame $w.in
	frame $w.lab
	frame $w.pr

	scale $w.in.2  -orient horizontal -from 0 -to 2000 -command \
                "set initialFuel" -bg Bisque1 -relief flat -length 200
	$w.in.2 set $initialFuel
	label $w.lab.2 -text "Fuel" -relief ridge
	scale $w.pr.2 -orient horizontal -from 0 -to 99 -command \
                "set itemEnergyPackProb" -bg Bisque1 -relief flat -length 200
        $w.pr.2 set $itemEnergyPackProb

	scale $w.in.3 -orient horizontal -from 0 -to 8 -command \
                "set initialTanks" -bg Bisque1 -relief flat -length 200
	$w.in.3 set $initialTanks
	label $w.lab.3 -text "Tanks" -relief ridge
	scale $w.pr.3 -orient horizontal -from 0 -to 99 -command \
                "set itemTankProb" -bg Bisque1 -relief flat -length 200
        $w.pr.3 set $itemTankProb

	scale $w.in.4 -orient horizontal -from 0 -to 10 -command \
                "set initialECMs" -bg Bisque1 -relief flat -length 200
        $w.in.4 set $initialECMs
	label $w.lab.4 -text "ECMs" -relief ridge
        scale $w.pr.4 -orient horizontal -from 0 -to 99 -command \
                "set itemECMProb" -bg Bisque1 -relief flat -length 200
        $w.pr.4 set $itemECMProb

        scale $w.in.5 -orient horizontal -from 0 -to 10 -command \
                "set_mines 1" -bg Bisque1 -relief flat -length 200
        $w.in.5 set $initialMines
        label $w.lab.5 -text "Mines" -relief ridge
	scale $w.pr.5 -orient horizontal -from 0 -to 99 -command \
                "set_mines 0" -bg Bisque1 -relief flat -length 200
        $w.pr.5 set $itemMineProb

        scale $w.in.6 -orient horizontal -from 0 -to 10 -command \
                "set_missiles 1" -bg Bisque1 -relief flat -length 200
        $w.in.6 set $initialMissiles
	label $w.lab.6 -text "Missiles" -relief ridge
        scale $w.pr.6 -orient horizontal -from 0 -to 99 -command \
                "set_missiles 0" -bg Bisque1 -relief flat -length 200
        $w.pr.6 set $itemMissileProb

        scale $w.in.7 -orient horizontal -from 0 -to 10 -command \
                "set initialCloaks" -bg Bisque1 -relief flat -length 200
        $w.in.7 set $initialCloaks
	label $w.lab.7 -text "Cloaks" -relief ridge
        scale $w.pr.7 -orient horizontal -from 0 -to 99 -command \
                "set itemCloakProb" -bg Bisque1 -relief flat -length 200
        $w.pr.7 set $itemCloakProb

        scale $w.in.8 -orient horizontal -from 0 -to 10 -command \
                "set initialSensors" -bg Bisque1 -relief flat -length 200
        $w.in.8 set $initialSensors
	label $w.lab.8 -text "Sensors" -relief ridge
        scale $w.pr.8 -orient horizontal -from 0 -to 99 -command \
                "set itemSensorProb" -bg Bisque1 -relief flat -length 200
        $w.pr.8 set $itemSensorProb

	scale $w.in.9 -orient horizontal -from 0 -to 10 -command \
                "set initialWideangles" -bg Bisque1 -relief flat -length 200
        $w.in.9 set $initialWideangles
	label $w.lab.9 -text "Wide angles" -relief ridge
	scale $w.pr.9 -orient horizontal -from 0 -to 99 -command \
                "set itemWideangleProb" -bg Bisque1 -relief flat -length 200
        $w.pr.9 set $itemWideangleProb

	scale $w.in.10 -orient horizontal -from 0 -to 10 -command \
                "set initialRearshots" -bg Bisque1 -relief flat -length 200
        $w.in.10 set $initialRearshots
	label $w.lab.10 -text "Rear shots" -relief ridge
	scale $w.pr.10 -orient horizontal -from 0 -to 99 -command \
                "set itemRearshotProb" -bg Bisque1 -relief flat -length 200
        $w.pr.10 set $itemRearshotProb

	scale $w.in.11 -orient horizontal -from 0 -to 10 -command \
                "set initialAfterburners" -bg Bisque1 -relief flat -length 200
        $w.in.11 set $initialAfterburners
	label $w.lab.11 -text "After burners" -relief ridge
        scale $w.pr.11 -orient horizontal -from 0 -to 99 -command \
                "set itemAfterburnerProb" -bg Bisque1 -relief flat -length 200
        $w.pr.11 set $itemAfterburnerProb

        scale $w.in.12 -orient horizontal -from 0 -to 5 -command \
                "set_lasers 1" -bg Bisque1 -relief flat -length 200
        $w.in.12 set $initialLasers
        label $w.lab.12 -text "Lasers" -relief ridge
	scale $w.pr.12 -orient horizontal -from 0 -to 99 -command \
                "set_lasers 0" -bg Bisque1 -relief flat -length 200
        $w.pr.12 set $itemLaserProb

	scale $w.in.13 -orient horizontal -from 0 -to 10 -command \
                "set initialEmergencyThrusts" -bg Bisque1 -relief flat -length 200
        $w.in.13 set $initialEmergencyThrusts
	label $w.lab.13 -text "Emergency Thrusts" -relief ridge
	scale $w.pr.13 -orient horizontal -from 0 -to 99 -command \
                "set itemEmergencyThrustProb" -bg Bisque1 -relief flat -length 200
        $w.pr.13 set $itemEmergencyThrustProb

	scale $w.in.14 -orient horizontal -from 0 -to 4 -command \
                "set initialTractorBeams" -bg Bisque1 -relief flat -length 200
        $w.in.14 set $initialTractorBeams
        label $w.lab.14 -text "Tractor Beams" -relief ridge
        scale $w.pr.14 -orient horizontal -from 0 -to 99 -command \
                "set itemTractorBeamProb" -bg Bisque1 -relief flat -length 200
        $w.pr.14 set $itemTractorBeamProb

        scale $w.in.15 -orient horizontal -from 0 -to 10 -command \
                "set initialAutopilots" -bg Bisque1 -relief flat -length 200
        $w.in.15 set $initialAutopilots
        label $w.lab.15 -text "Autopilots" -relief ridge
	scale $w.pr.15 -orient horizontal -from 0 -to 99 -command \
                "set itemAutopilotProb" -bg Bisque1 -relief flat -length 200
        $w.pr.15 set $itemAutopilotProb

	scale $w.in.16 -orient horizontal -from 0 -to 10 -command \
                "set initialTransporters" -bg Bisque1 -relief flat -length 200
        $w.in.16 set $initialTransporters
        label $w.lab.16 -text "Transporters" -relief ridge
	scale $w.pr.16 -orient horizontal -from 0 -to 99 -command \
                "set itemTransporterProb" -bg Bisque1 -relief flat -length 200
        $w.pr.16 set $itemTransporterProb

	pack $w.in.2 $w.in.3 $w.in.4 $w.in.5 $w.in.6 $w.in.7 $w.in.8 \
	        $w.in.9 $w.in.10 $w.in.11 $w.in.16 $w.in.12 $w.in.13 $w.in.14 \
	        $w.in.15 -side top -expand yes -fill both

	pack $w.lab.2 $w.lab.3 $w.lab.4 $w.lab.5 $w.lab.6 $w.lab.7 \
		$w.lab.8 $w.lab.9 $w.lab.10 $w.lab.11 $w.lab.16 $w.lab.12 \
		$w.lab.13 $w.lab.14 $w.lab.15 -side top -fill both -expand yes

        pack $w.pr.2 $w.pr.3 $w.pr.4 $w.pr.5 $w.pr.6 $w.pr.7 $w.pr.8 \
		$w.pr.9 $w.pr.10 $w.pr.11 $w.pr.16 $w.pr.12 $w.pr.13 $w.pr.14 \
		$w.pr.15 -side top -expand yes -fill both

	pack $w.in $w.lab $w.pr -side left -fill both -expand yes

	set b .mainpanel.items.others
	frame $b
	frame $b.moving
	label $b.moving.txt -text "Moving item prob (x100)"
	scale $b.moving.scale -orient horizontal -from 0 -to 99 -command \
		"set movingItemProb" -bg Bisque1 -relief flat -length 200
	pack $b.moving.txt $b.moving.scale -side top -expand yes -fill both
	$b.moving.scale set $movingItemProb

	frame $b.dpkill
	label $b.dpkill.txt -text "Drop item on kill prob (x100)"
	scale $b.dpkill.scale -orient horizontal -from 0 -to 99 -command \
		"set dropItemOnKillProb" -bg Bisque1 -relief flat -length 200
	pack $b.dpkill.txt $b.dpkill.scale -side top -expand yes -fill both
	$b.dpkill.scale set $dropItemOnKillProb

	frame $b.dstcol
	label $b.dstcol.txt -text "Crash item destroy prob (x100)"
	scale $b.dstcol.scale -orient horizontal -from 0 -to 99 -command \
		"set destroyItemInCollisionProb" -bg Bisque1 -relief flat \
		-length 200
	pack $b.dstcol.txt $b.dstcol.scale -side top -fill both -expand yes

	frame $b.mult
	label $b.mult.txt -text "Probability Multiplier"
	scale $b.mult.scale -orient horizontal -from 0 -to 20 -command \
                "set_prob" -bg Bisque1 -relief flat -length 200
	pack $b.mult.txt $b.mult.scale -side top -expand yes -fill both
        $b.mult.scale set $itemProbMult

	frame $b.maxden
	label $b.maxden.txt -text "Max item density"
	scale $b.maxden.scale -orient horizontal -from 0 -to 99 -command \
                "set maxItemDensity" -bg Bisque1 -relief flat -length 200
        pack $b.maxden.txt $b.maxden.scale -side top -expand yes -fill both
        $b.maxden.scale set $maxItemDensity

	frame $b.minsmarts
	label $b.minsmarts.txt -text "Min smarts for a nuke"
	scale $b.minsmarts.scale -orient horizontal -from 1 -to 16 -command \
		"set nukeMinSmarts" -bg Bisque1 -relief flat -length 200
	pack $b.minsmarts.txt $b.minsmarts.scale -side top -expand yes -fill both
	$b.minsmarts.scale set $nukeMinSmarts

	frame $b.minmines
	label $b.minmines.txt -text "Min mines for a nuke"
        scale $b.minmines.scale -orient horizontal -from 1 -to 16 -command \
                "set nukeMinMines" -bg Bisque1 -relief flat -length 200
        pack $b.minmines.txt $b.minmines.scale -side top -expand yes -fill both
	$b.minmines.scale set $nukeMinMines

	frame $b.nukeclus
	label $b.nukeclus.txt -text "Damage from a nuclear variant"
	scale $b.nukeclus.scale -orient horizontal -from 0 -to 99 -command \
                "set nukeClusterDamage"  -bg Bisque1 -relief flat -length 200
	pack $b.nukeclus.txt $b.nukeclus.scale -side top -expand yes -fill both
        $b.nukeclus.scale set $nukeClusterDamage

	frame $b.minefuse
	label $b.minefuse.txt -text "Mine fuse time (secs)"
	scale $b.minefuse.scale -orient horizontal -from 0 -to 300 -command \
		"set mineFuseTime" -bg Bisque1 -relief flat -length 200
        pack $b.minefuse.txt $b.minefuse.scale -side top -expand yes -fill both
        $b.minefuse.scale set $mineFuseTime
 
	set c .mainpanel.items.check

	frame $c
	checkbutton $c.crash -text "Allow player crashes" -variable \
		crashWithPlayer -relief flat -anchor w
	checkbutton $c.bounce -text "Allow player bouncing" -variable \
		bounceWithPlayer -relief flat -anchor w
	checkbutton $c.kills -text "Allow player killing" -variable \
		playerKillings -relief flat -anchor w
	checkbutton $c.shields -text "Allow shields" -variable playerShielding \
		-relief flat -anchor w -command "set_shields"
	checkbutton $c.stshld -text "Start shielded" -variable \
		playerStartsShielded -relief flat -anchor w
	checkbutton $c.nukes -text "Allow nukes" -variable allowNukes -relief \
		flat -anchor w
	checkbutton $c.clusters -text "Allow clusters" -variable allowClusters \
		-relief flat -anchor w
	checkbutton $c.modif -text "Allow modifiers " -variable allowModifiers \
		-relief flat -anchor w
	checkbutton $c.lmod -text "Allow laser modifiers" -variable \
		allowLaserModifiers -relief flat -anchor w
	checkbutton $c.shshps -text "Allow ship shapes" -variable \
		allowShipShapes -relief flat -anchor w
        checkbutton $c.plyrad -text "Players visible on radar" -variable \
		playersOnRadar -relief flat -anchor w
        checkbutton $c.misrad -text "Missiles visible on radar" -variable \
		missilesOnRadar -relief flat -anchor w
        checkbutton $c.minrad -text "Mines visible on radar" -variable \
                minesOnRadar -relief flat -anchor w
        checkbutton $c.nukerad -text "Nukes visible on radar" -variable \
		nukesOnRadar -relief flat -anchor w -command "set_nukes"
        checkbutton $c.dismis -text "Distinguish missiles" -variable \
		distinguishMissiles -relief flat -anchor w
        checkbutton $c.shldpu -text "Shielded item pickup" -variable \
		shieldedItemPickup -relief flat -anchor w
        checkbutton $c.shldmn -text "Shielded mining" -variable ShieldedMining \
		-relief flat -anchor w
	checkbutton $c.lasstn -text "Laser is a stun gun" -variable \
		laserIsStunGun -anchor w -relief flat
                
	pack $c.crash $c.bounce $c.kills $c.shields $c.stshld \
		$c.nukes $c.clusters $c.modif $c.lmod $c.shshps $c.plyrad \
		$c.misrad $c.minrad $c.nukerad $c.dismis $c.shldpu $c.shldmn \
		$c.lasstn -side top -fill both -expand yes

	pack $b.moving $b.dpkill $b.dstcol $b.mult \
		 $b.maxden $b.minsmarts $b.minmines \
		$b.nukeclus $b.minefuse -side top -fill both -expand yes

	pack .mainpanel.items.a.top .mainpanel.items.a.b -side top -fill both \
		-expand yes

	pack .mainpanel.items.a $c $b -side left
}
